/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.buildanatom.view;

import edu.colorado.phet.buildanatom.model.Atom;
import edu.colorado.phet.buildanatom.model.AtomListener;
import edu.colorado.phet.buildanatom.view.OrbitalView;
import edu.colorado.phet.common.phetcommon.math.Function;
import edu.colorado.phet.common.phetcommon.model.property.Property;
import edu.colorado.phet.common.phetcommon.util.SimpleObserver;
import edu.colorado.phet.common.phetcommon.view.graphics.RoundGradientPaint;
import edu.colorado.phet.common.phetcommon.view.graphics.transforms.ModelViewTransform;
import edu.colorado.phet.common.piccolophet.nodes.PhetPPath;
import edu.umd.cs.piccolo.PNode;
import java.awt.Color;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Point2D;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IsotopeElectronCloudNode
extends PNode {
    private static final Color CLOUD_BASE_COLOR = Color.BLUE;
    private final PhetPPath electronCloudNode;
    private static Map<Integer, Double> mapElectronCountToRadius = new HashMap<Integer, Double>(){
        {
            this.put(1, 38.0);
            this.put(2, 32.0);
            this.put(3, 134.0);
            this.put(4, 90.0);
            this.put(5, 82.0);
            this.put(6, 77.0);
            this.put(7, 75.0);
            this.put(8, 73.0);
            this.put(9, 71.0);
            this.put(10, 69.0);
        }
    };
    private static double minShellRadius = Double.MAX_VALUE;
    private static double maxShellRadius = 0.0;

    public IsotopeElectronCloudNode(final ModelViewTransform modelViewTransform, final Property<OrbitalView> property, final Atom atom) {
        atom.addAtomListener(new AtomListener.Adapter(){

            public void configurationChanged() {
                double d = IsotopeElectronCloudNode.this.getElectronShellDiameter(atom.getNumProtons());
                double d2 = atom.getPosition().getX();
                double d3 = atom.getPosition().getY();
                Shape shape = modelViewTransform.modelToView(new Ellipse2D.Double(d2 - d, d3 - d, d * 2.0, d * 2.0));
                IsotopeElectronCloudNode.this.electronCloudNode.setPathTo(shape);
                Function.LinearFunction linearFunction = new Function.LinearFunction(0.0, 10.0, 80.0, 110.0);
                int n = atom.getNumElectrons() == 0 ? 0 : (int)linearFunction.evaluate(atom.getNumElectrons());
                Paint paint = d > 0.0 ? new RoundGradientPaint(shape.getBounds2D().getCenterX(), shape.getBounds2D().getCenterY(), new Color(CLOUD_BASE_COLOR.getRed(), CLOUD_BASE_COLOR.getGreen(), CLOUD_BASE_COLOR.getBlue(), 0), new Point2D.Double(shape.getBounds2D().getWidth() / 3.0, shape.getBounds2D().getHeight() / 3.0), new Color(CLOUD_BASE_COLOR.getRed(), CLOUD_BASE_COLOR.getGreen(), CLOUD_BASE_COLOR.getBlue(), n)) : CLOUD_BASE_COLOR;
                IsotopeElectronCloudNode.this.electronCloudNode.setPaint(paint);
            }
        });
        Color color = new Color(0, 0, 0, 0);
        this.electronCloudNode = new PhetPPath(color){
            {
                super(paint);
                property.addObserver(new SimpleObserver(){

                    public void update() {
                        this.setVisible(property.get() == OrbitalView.ISOTOPES_RESIZING_CLOUD);
                    }
                });
            }
        };
        this.addChild(this.electronCloudNode);
    }

    private double getElectronShellDiameter(int n) {
        if (mapElectronCountToRadius.containsKey(n)) {
            return this.reduceRadiusRange(mapElectronCountToRadius.get(n));
        }
        if (n > 10) {
            System.out.println(this.getClass().getName() + " - Warning: Atom has more than supported number of electrons, " + n);
        }
        return 0.0;
    }

    private double reduceRadiusRange(double d) {
        double d2 = 40.0;
        double d3 = 100.0;
        Function.LinearFunction linearFunction = new Function.LinearFunction(minShellRadius, maxShellRadius, d2, d3);
        return linearFunction.evaluate(d);
    }

    static {
        for (Double d : mapElectronCountToRadius.values()) {
            if (d > maxShellRadius) {
                maxShellRadius = d;
            }
            if (!(d < minShellRadius)) continue;
            minShellRadius = d;
        }
    }
}

