/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.buildanatom.view;

import edu.colorado.phet.buildanatom.BuildAnAtomConstants;
import edu.colorado.phet.buildanatom.BuildAnAtomStrings;
import edu.colorado.phet.buildanatom.view.OrbitalView;
import edu.colorado.phet.common.phetcommon.model.property.Property;
import edu.colorado.phet.common.phetcommon.util.SimpleObserver;
import edu.colorado.phet.common.phetcommon.view.VerticalLayoutPanel;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.nodes.PText;
import edu.umd.cs.piccolox.pswing.PSwing;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ButtonGroup;
import javax.swing.JRadioButton;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OrbitalViewControl
extends PNode {
    public OrbitalViewControl(final Property<OrbitalView> property) {
        final PText pText = new PText(BuildAnAtomStrings.ELECTRON_MODEL){
            {
                this.setFont(BuildAnAtomConstants.WINDOW_TITLE_FONT);
            }
        };
        this.addChild(pText);
        VerticalLayoutPanel verticalLayoutPanel = new VerticalLayoutPanel(){
            {
                this.setOpaque(false);
                final ButtonGroup buttonGroup = new ButtonGroup();
                this.add(new JRadioButton(BuildAnAtomStrings.ELECTRON_MODEL_ORBITS, property.get() == OrbitalView.PARTICLES){
                    {
                        super(string, bl);
                        this.setOpaque(false);
                        buttonGroup.add(this);
                        this.setBackground(BuildAnAtomConstants.CANVAS_BACKGROUND);
                        this.setFont(BuildAnAtomConstants.ITEM_FONT);
                        this.addActionListener(new ActionListener(){

                            public void actionPerformed(ActionEvent actionEvent) {
                                property.set(OrbitalView.PARTICLES);
                            }
                        });
                        property.addObserver(new SimpleObserver(){

                            public void update() {
                                this.setSelected(property.get() == OrbitalView.PARTICLES);
                            }
                        });
                    }
                });
                this.add(new JRadioButton(BuildAnAtomStrings.ELECTRON_MODEL_CLOUD, property.get() == OrbitalView.RESIZING_CLOUD){
                    {
                        super(string, bl);
                        this.setOpaque(false);
                        buttonGroup.add(this);
                        this.setBackground(BuildAnAtomConstants.CANVAS_BACKGROUND);
                        this.setFont(BuildAnAtomConstants.ITEM_FONT);
                        this.addActionListener(new ActionListener(){

                            public void actionPerformed(ActionEvent actionEvent) {
                                property.set(OrbitalView.RESIZING_CLOUD);
                            }
                        });
                        property.addObserver(new SimpleObserver(){

                            public void update() {
                                this.setSelected(property.get() == OrbitalView.RESIZING_CLOUD);
                            }
                        });
                    }
                });
            }
        };
        this.addChild(new PSwing(verticalLayoutPanel){
            {
                super(jComponent);
                this.setOffset(pText.getFullBounds().getX(), pText.getFullBounds().getMaxY());
            }
        });
    }
}

