/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.buildanatom.view;

import edu.colorado.phet.buildanatom.model.Atom;
import edu.colorado.phet.buildanatom.model.Electron;
import edu.colorado.phet.buildanatom.model.ElectronShell;
import edu.colorado.phet.buildanatom.view.OrbitalView;
import edu.colorado.phet.common.phetcommon.math.Function;
import edu.colorado.phet.common.phetcommon.math.vector.Vector2D;
import edu.colorado.phet.common.phetcommon.model.property.Property;
import edu.colorado.phet.common.phetcommon.util.SimpleObserver;
import edu.colorado.phet.common.phetcommon.view.graphics.RoundGradientPaint;
import edu.colorado.phet.common.phetcommon.view.graphics.transforms.ModelViewTransform;
import edu.colorado.phet.common.piccolophet.event.CursorHandler;
import edu.colorado.phet.common.piccolophet.nodes.PhetPPath;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.event.PBasicInputEventHandler;
import edu.umd.cs.piccolo.event.PInputEvent;
import edu.umd.cs.piccolo.util.PDimension;
import java.awt.Color;
import java.awt.Shape;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Point2D;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResizingElectronCloudNode
extends PNode {
    private static final Color CLOUD_BASE_COLOR = Color.BLUE;
    private final PhetPPath electronCloudNode;
    private final ArrayList<ElectronShell> electronShells = new ArrayList();

    public ResizingElectronCloudNode(final ModelViewTransform modelViewTransform, final Property<OrbitalView> property, final Atom atom) {
        this.electronShells.add(atom.getElectronShells().get(0));
        this.electronShells.add(atom.getElectronShells().get(1));
        final double d = this.electronShells.get(0).getRadius();
        final double d2 = this.electronShells.get(this.electronShells.size() - 1).getRadius();
        SimpleObserver simpleObserver = new SimpleObserver(){

            public void update() {
                Function.LinearFunction linearFunction = new Function.LinearFunction(1.0, ResizingElectronCloudNode.this.getTotalElectronCapacity(), d, d2);
                double d4 = linearFunction.evaluate(ResizingElectronCloudNode.this.getElectronCount());
                double d22 = ((ElectronShell)ResizingElectronCloudNode.this.electronShells.get(0)).getCenterLocation().getX();
                double d3 = ((ElectronShell)ResizingElectronCloudNode.this.electronShells.get(0)).getCenterLocation().getY();
                Shape shape = modelViewTransform.modelToView(new Ellipse2D.Double(d22 - d4, d3 - d4, d4 * 2.0, d4 * 2.0));
                ResizingElectronCloudNode.this.electronCloudNode.setPathTo(shape);
                Function.LinearFunction linearFunction2 = new Function.LinearFunction(0.0, ResizingElectronCloudNode.this.getTotalElectronCapacity(), 50.0, 175.0);
                int n = ResizingElectronCloudNode.this.getElectronCount() == 0 ? 0 : (int)linearFunction2.evaluate(ResizingElectronCloudNode.this.getElectronCount());
                RoundGradientPaint roundGradientPaint = new RoundGradientPaint(shape.getBounds2D().getCenterX(), shape.getBounds2D().getCenterY(), new Color(CLOUD_BASE_COLOR.getRed(), CLOUD_BASE_COLOR.getGreen(), CLOUD_BASE_COLOR.getBlue(), n), new Point2D.Double(shape.getBounds2D().getWidth() / 3.0, shape.getBounds2D().getHeight() / 3.0), new Color(CLOUD_BASE_COLOR.getRed(), CLOUD_BASE_COLOR.getGreen(), CLOUD_BASE_COLOR.getBlue(), 0));
                ResizingElectronCloudNode.this.electronCloudNode.setPaint(roundGradientPaint);
            }
        };
        Color color = new Color(0, 0, 0, 0);
        this.electronCloudNode = new PhetPPath(color){
            {
                super(paint);
                property.addObserver(new SimpleObserver(){

                    public void update() {
                        this.setVisible(property.get() == OrbitalView.RESIZING_CLOUD);
                    }
                });
                SimpleObserver simpleObserver = new SimpleObserver(){

                    public void update() {
                        boolean bl = ResizingElectronCloudNode.this.getElectronCount() > 0 && property.get() == OrbitalView.RESIZING_CLOUD;
                        this.setPickable(bl);
                        this.setChildrenPickable(bl);
                    }
                };
                for (ElectronShell electronShell : ResizingElectronCloudNode.this.electronShells) {
                    electronShell.addObserver(simpleObserver);
                }
                property.addObserver(simpleObserver);
                this.addInputEventListener(new CursorHandler());
                this.addInputEventListener(new PBasicInputEventHandler(){
                    Electron grabbedElectron = null;

                    public void mousePressed(PInputEvent pInputEvent) {
                        Point2D point2D = modelViewTransform.viewToModel(pInputEvent.getPositionRelativeTo(this.getParent()));
                        this.grabbedElectron = atom.removeElectron();
                        this.grabbedElectron.setUserControlled(true);
                        this.grabbedElectron.setPositionAndDestination(point2D);
                    }

                    public void mouseDragged(PInputEvent pInputEvent) {
                        PDimension pDimension = pInputEvent.getDeltaRelativeTo(this.getParent());
                        this.grabbedElectron.translate(modelViewTransform.viewToModelDelta(new Vector2D(pDimension)));
                        this.grabbedElectron.setDestination(this.grabbedElectron.getPosition());
                    }

                    public void mouseReleased(PInputEvent pInputEvent) {
                        this.grabbedElectron.setUserControlled(false);
                        this.grabbedElectron = null;
                    }
                });
            }
        };
        this.addChild(this.electronCloudNode);
        for (ElectronShell electronShell : this.electronShells) {
            electronShell.addObserver(simpleObserver);
        }
    }

    private int getElectronCount() {
        int n = 0;
        for (ElectronShell electronShell : this.electronShells) {
            n += electronShell.getNumElectrons();
        }
        return n;
    }

    private int getTotalElectronCapacity() {
        int n = 0;
        for (ElectronShell electronShell : this.electronShells) {
            n += electronShell.getElectronCapacity();
        }
        return n;
    }
}

