/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.buildanatom.view;

import edu.colorado.phet.buildanatom.model.AtomListener;
import edu.colorado.phet.buildanatom.model.IDynamicAtom;
import edu.colorado.phet.common.phetcommon.view.PhetColorScheme;
import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import edu.colorado.phet.common.piccolophet.nodes.PhetPPath;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.nodes.PText;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.geom.Rectangle2D;

public class SymbolIndicatorNode
extends PNode {
    public static final Font SYMBOL_FONT = new PhetFont(28, true);
    public static final Font NUMBER_FONT = new PhetFont(20, true);
    public static final Font DEFAULT_ELEMENT_NAME_FONT = new PhetFont(12, true);
    private final IDynamicAtom atom;
    private final PText symbol;
    private final PText protonCount;
    private final PNode boundingBox;
    private final PText massNumberNode;
    private final PText chargeNode;
    private final PText elementName;
    private final PNode textContent;

    public SymbolIndicatorNode(IDynamicAtom iDynamicAtom, boolean bl) {
        this(iDynamicAtom, bl, true);
    }

    public SymbolIndicatorNode(IDynamicAtom iDynamicAtom, boolean bl, boolean bl2) {
        double d = 83.0;
        double d2 = 83.0;
        this.atom = iDynamicAtom;
        iDynamicAtom.addAtomListener(new AtomListener.Adapter(){

            public void configurationChanged() {
                SymbolIndicatorNode.this.updateSymbol();
            }
        });
        this.boundingBox = new PhetPPath(new Rectangle2D.Double(0.0, 0.0, d, d2), Color.white, new BasicStroke(1.0f), Color.black);
        this.addChild(this.boundingBox);
        this.textContent = new PNode();
        this.addChild(this.textContent);
        this.symbol = new PText();
        this.symbol.setFont(SYMBOL_FONT);
        this.textContent.addChild(this.symbol);
        this.protonCount = new PText();
        this.protonCount.setFont(NUMBER_FONT);
        this.protonCount.setTextPaint(PhetColorScheme.RED_COLORBLIND);
        this.textContent.addChild(this.protonCount);
        this.massNumberNode = new PText();
        this.massNumberNode.setFont(NUMBER_FONT);
        this.massNumberNode.setTextPaint(Color.BLACK);
        this.textContent.addChild(this.massNumberNode);
        this.chargeNode = new PText();
        this.chargeNode.setFont(NUMBER_FONT);
        if (bl2) {
            this.textContent.addChild(this.chargeNode);
        }
        this.elementName = new PText();
        this.elementName.setFont(DEFAULT_ELEMENT_NAME_FONT);
        this.elementName.setTextPaint(Color.RED);
        if (bl) {
            this.addChild(this.elementName);
        }
        this.updateSymbol();
    }

    private void updateSymbol() {
        this.symbol.setText(this.atom.getSymbol());
        this.symbol.setOffset(this.boundingBox.getFullBoundsReference().getCenterX() - this.symbol.getFullBoundsReference().width / 2.0, this.boundingBox.getFullBoundsReference().getCenterY() - this.symbol.getFullBoundsReference().height / 2.0);
        this.protonCount.setText(this.atom.getNumProtons() == 0 ? "" : "" + this.atom.getNumProtons());
        this.protonCount.setOffset(this.symbol.getFullBoundsReference().getMinX() - this.protonCount.getFullBoundsReference().width, this.symbol.getFullBoundsReference().getMaxY() - this.protonCount.getFullBounds().getHeight() * 0.35);
        if (this.chargeNode.getFullBounds().getMaxX() > this.boundingBox.getFullBounds().getMaxX()) {
            this.chargeNode.setOffset(this.boundingBox.getFullBounds().getMaxX() - this.chargeNode.getFullBounds().getWidth(), this.chargeNode.getOffset().getY());
        }
        if (this.protonCount.getFullBounds().getMinX() < this.boundingBox.getFullBounds().getMinX()) {
            this.protonCount.setOffset(this.boundingBox.getFullBounds().getMinX() + 2.0, this.protonCount.getFullBoundsReference().getY());
        }
        this.massNumberNode.setText(this.atom.getMassNumber() == 0 ? "" : "" + this.atom.getMassNumber());
        this.massNumberNode.setOffset(this.symbol.getFullBoundsReference().getMinX() - this.massNumberNode.getFullBoundsReference().width, this.symbol.getFullBoundsReference().getMinY() - this.massNumberNode.getFullBounds().getHeight() * 0.65);
        if (this.massNumberNode.getFullBounds().getMinX() < this.boundingBox.getFullBounds().getMinX()) {
            this.massNumberNode.setOffset(this.boundingBox.getFullBounds().getMinX() + 2.0, this.massNumberNode.getFullBoundsReference().getY());
        }
        this.chargeNode.setText(this.atom.getMassNumber() == 0 ? "" : this.atom.getFormattedCharge());
        Color color = Color.BLACK;
        if (this.atom.getCharge() > 0) {
            color = Color.RED;
        } else if (this.atom.getCharge() < 0) {
            color = Color.BLUE;
        }
        this.chargeNode.setTextPaint(color);
        this.chargeNode.setOffset(this.symbol.getFullBoundsReference().getMaxX(), this.symbol.getFullBoundsReference().getMinY() - this.chargeNode.getFullBounds().getHeight() * 0.65);
        if (this.chargeNode.getFullBounds().getMaxX() > this.boundingBox.getFullBounds().getMaxX()) {
            this.chargeNode.setOffset(this.boundingBox.getFullBounds().getMaxX() - this.chargeNode.getFullBounds().getWidth() - 2.0, this.chargeNode.getOffset().getY());
        }
        this.elementName.setText(this.atom.getName());
        if (this.elementName.getFullBoundsReference().width > this.boundingBox.getFullBoundsReference().width) {
            this.elementName.setScale(this.boundingBox.getFullBoundsReference().width / this.elementName.getFullBoundsReference().width);
        }
        this.elementName.setOffset(this.boundingBox.getFullBoundsReference().getCenterX() - this.elementName.getFullBoundsReference().width / 2.0, this.boundingBox.getFullBoundsReference().getMaxY());
        this.textContent.centerFullBoundsOnPoint(this.boundingBox.getFullBoundsReference().getCenterX(), this.boundingBox.getFullBoundsReference().getCenterY());
    }
}

