/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.phetcommon.view;

import edu.colorado.phet.common.phetcommon.model.Resettable;
import edu.colorado.phet.common.phetcommon.resources.PhetCommonResources;
import edu.colorado.phet.common.phetcommon.simsharing.SimSharingManager;
import edu.colorado.phet.common.phetcommon.simsharing.messages.SystemActions;
import edu.colorado.phet.common.phetcommon.simsharing.messages.SystemComponentTypes;
import edu.colorado.phet.common.phetcommon.simsharing.messages.SystemComponents;
import edu.colorado.phet.common.phetcommon.simsharing.messages.UserActions;
import edu.colorado.phet.common.phetcommon.simsharing.messages.UserComponentTypes;
import edu.colorado.phet.common.phetcommon.simsharing.messages.UserComponents;
import edu.colorado.phet.common.phetcommon.view.util.PhetOptionPane;
import java.awt.Component;
import java.util.Vector;

public class ResetAllDelegate {
    private final Vector<Resettable> resettables = new Vector();
    private final Component parent;
    private boolean confirmationEnabled;

    public ResetAllDelegate(Resettable[] resettableArray, Component component) {
        for (Resettable resettable : resettableArray) {
            this.resettables.add(resettable);
        }
        this.parent = component;
        this.confirmationEnabled = true;
    }

    public void setConfirmationEnabled(boolean bl) {
        this.confirmationEnabled = bl;
    }

    public void resetAll() {
        if (!this.confirmationEnabled || this.confirmReset()) {
            for (Resettable resettable : this.resettables) {
                resettable.reset();
            }
        }
    }

    private boolean confirmReset() {
        SimSharingManager.sendSystemMessage(SystemComponents.resetAllConfirmationDialog, SystemComponentTypes.dialog, SystemActions.windowOpened);
        String string = PhetCommonResources.getInstance().getLocalizedString("ControlPanel.message.confirmResetAll");
        String string2 = PhetCommonResources.getInstance().getLocalizedString("Common.title.confirm");
        int n = PhetOptionPane.showYesNoDialog(this.parent, string, string2);
        boolean bl = n == 0;
        SimSharingManager.sendUserMessage(bl ? UserComponents.resetAllConfirmationDialogYesButton : UserComponents.resetAllConfirmationDialogNoButton, UserComponentTypes.button, UserActions.pressed);
        return bl;
    }
}

