/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.piccolophet.nodes;

import edu.umd.cs.piccolo.nodes.PPath;
import edu.umd.cs.piccolox.nodes.PComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.geom.Arc2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Rectangle2D;

public class FaceNode
extends PComposite {
    private static final Color HEAD_COLOR = Color.YELLOW;
    private static final Color EYE_COLOR = Color.BLACK;
    private static final Color MOUTH_COLOR = Color.BLACK;
    private final PPath smileNode;
    private final PPath frownNode;

    public FaceNode(double d, Paint paint, Paint paint2, Paint paint3) {
        double d2 = (double)0.15f * d;
        double d3 = d / 4.0;
        BasicStroke basicStroke = new BasicStroke(Math.max(1.0f, (float)(d / 25.0)), 1, 1);
        CircleNode circleNode = new CircleNode(d, paint);
        CircleNode circleNode2 = new CircleNode(d2, paint2);
        CircleNode circleNode3 = new CircleNode(d2, paint2);
        this.smileNode = new SmileNode(d3, paint3, basicStroke);
        this.frownNode = new FrownNode(d3, paint3, basicStroke);
        this.addChild(circleNode);
        this.addChild(circleNode2);
        this.addChild(circleNode3);
        this.addChild(this.smileNode);
        this.addChild(this.frownNode);
        double d4 = 0.0;
        double d5 = 0.0;
        circleNode.setOffset(d4, d5);
        d4 = 0.3 * d - circleNode2.getWidth() / 2.0;
        d5 = 0.4 * d - circleNode2.getHeight() / 2.0;
        circleNode2.setOffset(d4, d5);
        d4 = d - circleNode2.getXOffset() - circleNode3.getWidth();
        d5 = circleNode2.getYOffset();
        circleNode3.setOffset(d4, d5);
        d4 = 0.5 * d;
        d5 = 0.55 * d;
        this.smileNode.setOffset(d4, d5);
        d4 = this.smileNode.getXOffset();
        d5 = 0.65 * d;
        this.frownNode.setOffset(d4, d5);
        this.smile();
    }

    public void smile() {
        this.smileNode.setVisible(true);
        this.frownNode.setVisible(false);
    }

    public void frown() {
        this.smileNode.setVisible(false);
        this.frownNode.setVisible(true);
    }

    private static class CircleNode
    extends PPath {
        public CircleNode(double d, Paint paint) {
            this.setPathTo(new Ellipse2D.Double(0.0, 0.0, d, d));
            this.setPaint(paint);
            this.setStroke(null);
        }
    }

    private static class FrownNode
    extends PPath {
        public FrownNode(double d, Paint paint, Stroke stroke) {
            this.setPathTo(new Arc2D.Double(new Rectangle2D.Double(-d, 0.0, 2.0 * d, 2.0 * d), 40.0, 100.0, 0));
            this.setStrokePaint(paint);
            this.setStroke(stroke);
        }
    }

    private static class SmileNode
    extends PPath {
        public SmileNode(double d, Paint paint, Stroke stroke) {
            this.setPathTo(new Arc2D.Double(new Rectangle2D.Double(-d, -d, 2.0 * d, 2.0 * d), -30.0, -120.0, 0));
            this.setStrokePaint(paint);
            this.setStroke(stroke);
        }
    }
}

