/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.piccolophet.nodes;

import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.nodes.PPath;
import java.awt.Color;
import java.awt.Rectangle;
import java.awt.geom.Arc2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.List;

public class PieChartNode
extends PNode {
    private PieValue[] slices;
    private Rectangle area;
    private double initialAngle = 0.0;
    private final List<Point2D> sliceEdgeCenterPoints = new ArrayList<Point2D>();

    public PieChartNode(PieValue[] pieValueArray, Rectangle rectangle) {
        this.validateValues(pieValueArray);
        this.slices = pieValueArray;
        this.area = rectangle;
        this.update();
    }

    private void validateValues(PieValue[] pieValueArray) {
        for (PieValue pieValue : pieValueArray) {
            if (!(pieValue.getValue() < 0.0)) continue;
            throw new IllegalArgumentException("Pie value was negative");
        }
    }

    public void setPieValues(PieValue[] pieValueArray) {
        this.validateValues(pieValueArray);
        this.slices = pieValueArray;
        this.update();
    }

    public void setInitialAngle(double d) {
        this.initialAngle = d;
        this.update();
    }

    private void update() {
        this.removeAllChildren();
        this.sliceEdgeCenterPoints.clear();
        double d = this.getTotal();
        if (d == 0.0) {
            return;
        }
        double d2 = Math.toDegrees(this.initialAngle);
        double d3 = 0.0;
        for (int i = 0; i < this.slices.length; ++i) {
            double d4 = d3 * 360.0 / d + d2;
            double d5 = this.slices[i].value * 360.0 / d;
            if (i == this.slices.length - 1) {
                d5 = 360.0 - d4 + d2;
            }
            if (this.slices[i].getValue() > 0.0) {
                PPath pPath;
                if (this.slices[i].getValue() == d) {
                    pPath = new PPath(new Ellipse2D.Double(this.area.x, this.area.y, this.area.width, this.area.height));
                    this.sliceEdgeCenterPoints.add(new Point2D.Double(this.area.getMinX(), this.area.getCenterY()));
                } else {
                    pPath = new PPath(new Arc2D.Double(this.area.x, this.area.y, this.area.width, this.area.height, d4, d5, 2));
                    double d6 = Math.round((double)this.area.width / 2.0);
                    double d7 = -Math.toRadians(d4 + d5 / 2.0);
                    this.sliceEdgeCenterPoints.add(new Point2D.Double(Math.cos(d7) * d6, Math.sin(d7) * d6));
                }
                pPath.setPaint(this.slices[i].color);
                this.addChild(pPath);
            } else {
                this.sliceEdgeCenterPoints.add(null);
            }
            d3 += this.slices[i].value;
        }
    }

    public Point2D getCenterEdgePtForSlice(int n) {
        if (n < this.sliceEdgeCenterPoints.size() && this.sliceEdgeCenterPoints.get(n) != null) {
            return new Point2D.Double(this.sliceEdgeCenterPoints.get(n).getX(), this.sliceEdgeCenterPoints.get(n).getY());
        }
        System.err.println(this.getClass().getName() + " - Error: No such slice, val = " + n);
        return null;
    }

    public double getTotal() {
        double d = 0.0;
        for (int i = 0; i < this.slices.length; ++i) {
            d += this.slices[i].value;
        }
        return d;
    }

    public static class PieValue {
        double value;
        Color color;

        public PieValue(double d, Color color) {
            this.value = d;
            this.color = color;
        }

        public double getValue() {
            return this.value;
        }

        public void setValue(double d) {
            this.value = d;
        }
    }
}

