/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.phetcommon.servicemanager;

import edu.colorado.phet.common.phetcommon.resources.PhetCommonResources;
import edu.colorado.phet.common.phetcommon.servicemanager.InputStreamFileContents;
import edu.colorado.phet.common.phetcommon.servicemanager.LocalFileContent;
import edu.colorado.phet.common.phetcommon.servicemanager.LocalFileFilter;
import edu.colorado.phet.common.phetcommon.view.util.PhetOptionPane;
import java.awt.Component;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.jnlp.FileContents;
import javax.jnlp.FileSaveService;
import javax.swing.JFileChooser;

public class LocalFileSaveService
implements FileSaveService {
    Component owner;

    public LocalFileSaveService(Component component) {
        this.owner = component;
    }

    public FileContents saveAsFileDialog(String string, String[] stringArray, FileContents fileContents) throws IOException {
        int n;
        JFileChooser jFileChooser = new JFileChooser(string);
        if (stringArray != null && stringArray.length > 0) {
            LocalFileFilter localFileFilter = new LocalFileFilter(stringArray);
            jFileChooser.setFileFilter(localFileFilter);
        }
        if ((n = jFileChooser.showSaveDialog(this.owner)) == 1) {
            System.out.println("Cancelled.");
            return null;
        }
        if (n == -1) {
            System.out.println("Error");
            return null;
        }
        if (n == 0) {
            Object object;
            File file = jFileChooser.getSelectedFile();
            System.out.println("Selected file f=" + file);
            if (!file.exists()) {
                file.getParentFile().mkdirs();
                file.createNewFile();
            } else {
                object = PhetCommonResources.getInstance().getLocalizedString("Save.confirm.message");
                int n2 = PhetOptionPane.showYesNoDialog(this.owner, object);
                if (n2 != 0) {
                    return null;
                }
            }
            object = new LocalFileContent(file);
            byte[] byArray = new byte[(int)fileContents.getLength()];
            InputStream inputStream = fileContents.getInputStream();
            int n3 = 0;
            while ((n3 = inputStream.read(byArray, n3, byArray.length - n3)) > 0) {
            }
            inputStream.close();
            if (file.canWrite()) {
                FileOutputStream fileOutputStream = new FileOutputStream(file);
                fileOutputStream.write(byArray);
            }
            return object;
        }
        return null;
    }

    public FileContents saveFileDialog(String string, String[] stringArray, InputStream inputStream, String string2) throws IOException {
        return this.saveAsFileDialog(string, stringArray, new InputStreamFileContents(string2, inputStream));
    }
}

