/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.phetcommon.view.util;

import java.awt.Color;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.ColorModel;

public class MakeDuotoneImageOp
implements BufferedImageOp {
    private Color baseColor;

    public MakeDuotoneImageOp(Color color) {
        assert (color != null);
        this.baseColor = color;
    }

    public RenderingHints getRenderingHints() {
        return null;
    }

    public Rectangle2D getBounds2D(BufferedImage bufferedImage) {
        return new Rectangle2D.Double(0.0, 0.0, bufferedImage.getWidth(), bufferedImage.getHeight());
    }

    public Point2D getPoint2D(Point2D point2D, Point2D point2D2) {
        if (point2D2 == null) {
            point2D2 = new Point2D.Double();
        }
        point2D2.setLocation(point2D.getX(), point2D.getY());
        return point2D2;
    }

    public BufferedImage filter(BufferedImage bufferedImage, BufferedImage bufferedImage2) {
        if (bufferedImage2 == null) {
            bufferedImage2 = this.createCompatibleDestImage(bufferedImage, bufferedImage.getColorModel());
        }
        ColorModel colorModel = bufferedImage.getColorModel();
        double d = MakeDuotoneImageOp.getGrayLevel(this.baseColor);
        for (int i = 0; i < bufferedImage.getWidth(); ++i) {
            for (int j = 0; j < bufferedImage.getHeight(); ++j) {
                int n = bufferedImage.getRGB(i, j);
                int n2 = colorModel.getAlpha(n);
                int n3 = colorModel.getRed(n);
                int n4 = colorModel.getGreen(n);
                int n5 = colorModel.getBlue(n);
                int n6 = MakeDuotoneImageOp.getDuoToneRGB(n3, n4, n5, n2, d, this.baseColor);
                bufferedImage2.setRGB(i, j, n6);
            }
        }
        return bufferedImage2;
    }

    public static int getDuoToneRGB(int n, int n2, int n3, int n4, double d, Color color) {
        double d2 = (n + n2 + n3) / 3;
        int n5 = MakeDuotoneImageOp.getComponent(d2, color.getRed(), d);
        int n6 = MakeDuotoneImageOp.getComponent(d2, color.getGreen(), d);
        int n7 = MakeDuotoneImageOp.getComponent(d2, color.getBlue(), d);
        int n8 = n4 * 0x1000000 + n5 * 65536 + n6 * 256 + n7 * 1;
        return n8;
    }

    public static double getGrayLevel(Color color) {
        double d = (color.getRed() + color.getGreen() + color.getBlue()) / 765;
        return d;
    }

    public BufferedImage createCompatibleDestImage(BufferedImage bufferedImage, ColorModel colorModel) {
        return new AffineTransformOp(new AffineTransform(), 1).createCompatibleDestImage(bufferedImage, colorModel);
    }

    private static int getComponent(double d, double d2, double d3) {
        double d4;
        double d5;
        int n = 0;
        if (d == 255.0) {
            n = 255;
        }
        if (d >= d3 && d < 255.0) {
            d5 = (255.0 - d2) / (255.0 - d3);
            d4 = d2 + (d - d3) * d5;
            n = (int)d4;
        }
        if (d <= d3 && d < 255.0) {
            d5 = d2 / d3;
            d4 = (d - d3) * d5;
            n = (int)d4;
            n = (int)(d / d3 * d2);
        }
        return n;
    }
}

