/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.idealgas;

import edu.colorado.phet.common.phetcommon.application.ApplicationConstructor;
import edu.colorado.phet.common.phetcommon.application.Module;
import edu.colorado.phet.common.phetcommon.application.PhetApplication;
import edu.colorado.phet.common.phetcommon.application.PhetApplicationConfig;
import edu.colorado.phet.common.phetcommon.application.PhetApplicationLauncher;
import edu.colorado.phet.common.phetgraphics.application.PhetGraphicsModule;
import edu.colorado.phet.common.phetgraphics.view.ApparatusPanel;
import edu.colorado.phet.idealgas.IdealGasConfig;
import edu.colorado.phet.idealgas.IdealGasLookAndFeel;
import edu.colorado.phet.idealgas.controller.MovableWallsModule;
import edu.colorado.phet.idealgas.model.IdealGasClock;
import java.awt.Color;

public class ReversibleReactionsApplication
extends PhetApplication {
    private MovableWallsModule wallsModule;

    public ReversibleReactionsApplication(PhetApplicationConfig phetApplicationConfig) {
        super(phetApplicationConfig);
        IdealGasClock idealGasClock = new IdealGasClock(40, 0.1f);
        this.wallsModule = new MovableWallsModule(idealGasClock){

            protected void addHelp() {
                this.addStoveHelp();
            }
        };
        this.setModules(new Module[]{this.wallsModule});
    }

    protected void parseArgs(String[] stringArray) {
        super.parseArgs(stringArray);
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            if (!string.startsWith("-B")) continue;
            PhetGraphicsModule[] phetGraphicsModuleArray = (PhetGraphicsModule[])this.getModules();
            for (int j = 0; j < phetGraphicsModuleArray.length; ++j) {
                ApparatusPanel apparatusPanel = phetGraphicsModuleArray[j].getApparatusPanel();
                apparatusPanel.setBackground(Color.black);
                apparatusPanel.paintImmediately(apparatusPanel.getBounds());
            }
        }
    }

    public static void main(String[] stringArray) {
        ApplicationConstructor applicationConstructor = new ApplicationConstructor(){

            public PhetApplication getApplication(PhetApplicationConfig phetApplicationConfig) {
                return new ReversibleReactionsApplication(phetApplicationConfig);
            }
        };
        PhetApplicationConfig phetApplicationConfig = new PhetApplicationConfig(stringArray, "ideal-gas", "reversible-reactions");
        phetApplicationConfig.setLookAndFeel(new IdealGasLookAndFeel());
        phetApplicationConfig.setFrameSetup(IdealGasConfig.FRAME_SETUP);
        new PhetApplicationLauncher().launchSim(phetApplicationConfig, applicationConstructor);
    }
}

