/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.idealgas.collision;

import edu.colorado.phet.common.mechanics.Body;
import edu.colorado.phet.idealgas.IdealGasConfig;
import edu.colorado.phet.idealgas.collision.CollidableBody;
import edu.colorado.phet.idealgas.collision.CollisionExpert;
import edu.colorado.phet.idealgas.collision.SphericalBody;
import edu.colorado.phet.idealgas.collision.Wall;
import edu.colorado.phet.idealgas.model.Box2D;
import edu.colorado.phet.idealgas.model.GasMolecule;
import edu.colorado.phet.idealgas.model.IdealGasModel;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public class CollisionGod {
    private int numRegionsX;
    private int numRegionsY;
    private Region[][] regions;
    private HashMap elementToRegionMap = new HashMap();
    private ArrayList removalList = new ArrayList();
    private double regionWidth;
    private double regionHeight;
    public static boolean overlappingRegions = true;
    private IdealGasModel model;
    private double dt;
    private Rectangle2D.Double bounds;
    private double regionOverlap;
    private List collisionExperts;
    private Box2D box;
    private HashMap wallToRegion = new HashMap();

    public CollisionGod(IdealGasModel idealGasModel, double d, Rectangle2D.Double double_, int n, int n2) {
        this.model = idealGasModel;
        this.dt = d;
        this.bounds = double_;
        this.numRegionsX = n;
        this.numRegionsY = n2;
        this.regions = new Region[n][n2];
        this.regionWidth = double_.getWidth() / (double)n;
        this.regionHeight = double_.getHeight() / (double)n2;
        this.regionOverlap = 2.0f * GasMolecule.s_radius;
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                this.regions[i][j] = overlappingRegions ? new Region(double_.getX() + (double)i * this.regionWidth, double_.getX() + (double)(i + 1) * this.regionWidth + this.regionOverlap, double_.getY() + (double)j * this.regionHeight, double_.getY() + (double)(j + 1) * this.regionHeight + this.regionOverlap) : new Region(double_.getX() + (double)i * this.regionWidth, double_.getX() + (double)(i + 1) * this.regionWidth - -4.9E-324, double_.getY() + (double)j * this.regionHeight, double_.getY() + (double)(j + 1) * this.regionHeight - Double.MIN_VALUE);
            }
        }
    }

    public void doYourThing(double d, List list) {
        this.collisionExperts = list;
        List list2 = this.model.getBodies();
        this.adjustRegionMembership(list2);
        this.adjustMoleculeWallRelations(list2);
        this.doGasToGasCollisions();
        this.doMiscCollisions(list2);
        for (int i = 0; i < this.regions.length; ++i) {
            Region[] regionArray = this.regions[i];
            for (int j = 0; j < regionArray.length; ++j) {
                Region region = regionArray[j];
                region.clear();
            }
        }
        this.keepMoleculesInBox(list2);
    }

    private void adjustMoleculeWallRelations(List list) {
        CollidableBody collidableBody;
        int n;
        ArrayList<CollidableBody> arrayList = new ArrayList<CollidableBody>();
        for (n = 0; n < list.size(); ++n) {
            collidableBody = (CollidableBody)list.get(n);
            if (!(collidableBody instanceof Wall)) continue;
            arrayList.add(collidableBody);
        }
        for (n = 0; n < list.size(); ++n) {
            collidableBody = (CollidableBody)list.get(n);
            if (!(collidableBody instanceof GasMolecule)) continue;
            GasMolecule gasMolecule = (GasMolecule)collidableBody;
            for (int i = 0; i < arrayList.size(); ++i) {
                Wall wall = (Wall)arrayList.get(i);
                if (!(gasMolecule.getPosition().getX() < wall.getBounds().getMinX() + wall.getBounds().getWidth() / 2.0)) continue;
                MoleculeDescriptor moleculeDescriptor = (MoleculeDescriptor)this.wallToRegion.get(gasMolecule);
                if (moleculeDescriptor == null) {
                    moleculeDescriptor = new MoleculeDescriptor(wall, gasMolecule);
                    this.wallToRegion.put(wall, moleculeDescriptor);
                    continue;
                }
                moleculeDescriptor.update();
            }
        }
    }

    private void keepMoleculesInBox(List list) {
        Body body;
        int n;
        this.box = null;
        if (this.box == null) {
            for (n = 0; n < list.size(); ++n) {
                body = (Body)list.get(n);
                if (!(body instanceof Box2D)) continue;
                this.box = (Box2D)body;
                break;
            }
        }
        for (n = 0; n < list.size(); ++n) {
            body = (Body)list.get(n);
            if (!(body instanceof GasMolecule)) continue;
            GasMolecule gasMolecule = (GasMolecule)body;
            if (gasMolecule.getPosition().getX() + gasMolecule.getRadius() > this.box.getMaxX()) {
                gasMolecule.setPosition(this.box.getMaxX() - gasMolecule.getRadius(), gasMolecule.getPosition().getY());
            }
            if (!(gasMolecule.getPosition().getY() + gasMolecule.getRadius() > this.box.getMaxY())) continue;
            gasMolecule.setPosition(gasMolecule.getPosition().getX(), this.box.getMaxY() - gasMolecule.getRadius());
        }
    }

    private void adjustRegionMembership(List list) {
        Object object;
        for (int i = 0; i < list.size(); ++i) {
            object = (Body)list.get(i);
            if (!(object instanceof GasMolecule)) continue;
            if (overlappingRegions) {
                this.assignRegions((Body)object);
                continue;
            }
            if (this.elementToRegionMap.containsKey(object)) {
                this.placeBody((Body)object);
                continue;
            }
            this.addBody((Body)object);
        }
        this.removalList.clear();
        Set set = this.elementToRegionMap.keySet();
        for (Object e : set) {
            if (!(e instanceof GasMolecule) || list.contains(e)) continue;
            this.removalList.add(e);
        }
        while (!this.removalList.isEmpty()) {
            object = (Body)this.removalList.remove(0);
            this.removeBody((Body)object);
        }
    }

    private void doMiscCollisions(List list) {
        int n;
        Object object;
        int n2;
        Box2D box2D = null;
        ArrayList arrayList = new ArrayList();
        ArrayList arrayList2 = new ArrayList();
        for (n2 = 0; n2 < list.size(); ++n2) {
            object = list.get(n2);
            if (object instanceof GasMolecule) continue;
            if (object instanceof Box2D) {
                box2D = (Box2D)object;
                continue;
            }
            if (object instanceof Wall) {
                arrayList.add(object);
                continue;
            }
            arrayList2.add(object);
        }
        for (n2 = 0; n2 < arrayList2.size(); ++n2) {
            object = (CollidableBody)arrayList2.get(n2);
            for (n = 0; n < list.size(); ++n) {
                CollidableBody collidableBody = (CollidableBody)list.get(n);
                if (object == collidableBody) continue;
                this.detectAndDoCollision((CollidableBody)object, collidableBody);
            }
        }
        for (n2 = 0; n2 < list.size(); ++n2) {
            object = (CollidableBody)list.get(n2);
            n = 0;
            do {
                n = 0;
                for (int i = 0; i < arrayList.size() && n == 0; ++i) {
                    Wall wall = (Wall)arrayList.get(i);
                    n = this.detectAndDoCollision((CollidableBody)object, wall) ? 1 : 0;
                }
                if (object == box2D || n != 0) continue;
                n = this.detectAndDoCollision((CollidableBody)object, box2D) ? 1 : 0;
            } while (n != 0);
        }
        for (n2 = 0; n2 < list.size(); ++n2) {
            object = (CollidableBody)list.get(n2);
            if (!(object instanceof GasMolecule)) continue;
            GasMolecule gasMolecule = (GasMolecule)object;
            boolean bl = false;
            do {
                bl = false;
                for (int i = 0; i < arrayList.size(); ++i) {
                    Wall wall = (Wall)arrayList.get(i);
                    if (!wall.getBounds().contains(gasMolecule.getPosition())) continue;
                    wall.fixup(gasMolecule);
                    bl = true;
                }
            } while (bl);
        }
    }

    private void doGasToGasCollisions() {
        for (int i = 0; i < this.numRegionsX; ++i) {
            for (int j = 0; j < this.numRegionsY; ++j) {
                this.doRegionToRegionCollision(this.regions[i][j], this.regions[i][j]);
                if (overlappingRegions) continue;
                if (i < this.numRegionsX - 1) {
                    this.doRegionToRegionCollision(this.regions[i][j], this.regions[i + 1][j]);
                }
                if (j < this.numRegionsY - 1) {
                    this.doRegionToRegionCollision(this.regions[i][j], this.regions[i][j + 1]);
                }
                if (i >= this.numRegionsX - 1 || j >= this.numRegionsY - 1) continue;
                this.doRegionToRegionCollision(this.regions[i][j], this.regions[i + 1][j + 1]);
            }
        }
    }

    private void doRegionToRegionCollision(Region region, Region region2) {
        for (int i = 0; i < region.size(); ++i) {
            int n;
            CollidableBody collidableBody = (CollidableBody)region.get(i);
            for (int j = n = region == region2 ? i + 1 : 0; j < region2.size(); ++j) {
                CollidableBody collidableBody2 = (CollidableBody)region2.get(j);
                if (collidableBody == collidableBody2) continue;
                this.detectAndDoCollision(collidableBody, collidableBody2);
            }
        }
    }

    private boolean detectAndDoCollision(CollidableBody collidableBody, CollidableBody collidableBody2) {
        boolean bl = false;
        for (int i = 0; i < this.collisionExperts.size(); ++i) {
            CollisionExpert collisionExpert = (CollisionExpert)this.collisionExperts.get(i);
            bl |= collisionExpert.detectAndDoCollision(collidableBody, collidableBody2);
        }
        return bl;
    }

    private void addBody(Body body) {
        if (overlappingRegions) {
            this.assignRegions(body);
        } else {
            Region region = this.findRegionFor(body);
            this.elementToRegionMap.put(body, region);
            if (region == null) {
                System.out.println("halt");
            }
            region.add(body);
        }
    }

    private void removeBody(Body body) {
        if (overlappingRegions) {
            int n = this.numRegionsX;
            int n2 = this.numRegionsY;
            for (int i = 0; i < n; ++i) {
                for (int j = 0; j < n2; ++j) {
                    if (!this.regions[i][j].contains(body)) continue;
                    n = Math.min(i + 2, this.numRegionsX);
                    n2 = Math.min(j + 2, this.numRegionsY);
                    this.regions[i][j].remove(body);
                }
            }
        } else {
            ((Region)this.elementToRegionMap.get(body)).remove(body);
            this.elementToRegionMap.remove(body);
        }
    }

    private void assignRegions(Body body) {
        double d = body.getPosition().getX();
        double d2 = body.getPosition().getY();
        try {
            int n = (int)((d - this.bounds.x) / this.regionWidth);
            int n2 = (int)((d - this.regionOverlap - this.bounds.x) / this.regionWidth);
            int n3 = (int)((d2 - this.bounds.y) / this.regionHeight);
            int n4 = (int)((d2 - this.regionOverlap - this.bounds.y) / this.regionHeight);
            this.regions[n][n3].add(body);
            if (n != n2) {
                this.regions[n2][n3].add(body);
            }
            if (n3 != n4) {
                this.regions[n][n4].add(body);
            }
            if (n != n2 && n3 != n4) {
                this.regions[n2][n4].add(body);
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            System.out.println("ArrayIndexOutOfBoundsException in CollisionGod.assignRegions()");
        }
    }

    private Region findRegionFor(Body body) {
        Region region = null;
        if (IdealGasConfig.REGION_TEST) {
            int n = (int)(body.getPosition().getX() / this.regionWidth);
            int n2 = (int)(body.getPosition().getY() / this.regionHeight);
            region = this.regions[n][n2];
        } else {
            for (int i = 0; region == null && i < this.numRegionsX; ++i) {
                for (int j = 0; region == null && j < this.numRegionsY; ++j) {
                    if (!this.regions[i][j].belongsIn(body)) continue;
                    region = this.regions[i][j];
                }
            }
        }
        return region;
    }

    private void placeBody(Body body) {
        Region region = (Region)this.elementToRegionMap.get(body);
        if (region == null) {
            this.addBody(body);
        } else if (!region.belongsIn(body)) {
            region.remove(body);
            this.addBody(body);
        }
    }

    private class MoleculeDescriptor {
        int xDesc;
        int yDesc;
        private Wall wall;
        private SphericalBody sphere;

        public MoleculeDescriptor(Wall wall, SphericalBody sphericalBody) {
            this.wall = wall;
            this.sphere = sphericalBody;
            this.update();
        }

        public void update() {
            this.xDesc = this.sphere.getPosition().getX() < this.wall.getBounds().getMinX() + this.wall.getBounds().getWidth() / 2.0 ? 1 : 2;
            this.yDesc = this.sphere.getPosition().getY() < this.wall.getBounds().getMinY() + this.wall.getBounds().getHeight() / 2.0 ? 3 : 4;
        }
    }

    public class Region
    extends LinkedList {
        double xMin;
        double xMax;
        double yMin;
        double yMax;

        Region(double d, double d2, double d3, double d4) {
            this.xMin = d;
            this.xMax = d2;
            this.yMin = d3;
            this.yMax = d4;
        }

        boolean belongsIn(Body body) {
            boolean bl = body.getPosition().getX() >= this.xMin && body.getPosition().getX() <= this.xMax && body.getPosition().getY() >= this.yMin && body.getPosition().getY() <= this.yMax;
            return bl;
        }
    }
}

