/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.idealgas.collision;

import edu.colorado.phet.idealgas.collision.CollidableBody;
import edu.colorado.phet.idealgas.collision.ContactDetector;
import edu.colorado.phet.idealgas.collision.SolidSphere;
import edu.colorado.phet.idealgas.collision.SphereHollowSphereContactDetector;
import edu.colorado.phet.idealgas.collision.SphericalBody;
import edu.colorado.phet.idealgas.model.HotAirBalloon;

public class SphereHotAirBalloonContactDetector
implements ContactDetector {
    private SphereHollowSphereContactDetector detector = new SphereHollowSphereContactDetector();

    public boolean areInContact(CollidableBody collidableBody, CollidableBody collidableBody2) {
        boolean bl = false;
        if (!this.applies(collidableBody, collidableBody2)) {
            return false;
        }
        if (collidableBody.getClass() == collidableBody2.getClass()) {
            throw new RuntimeException("bad arguments");
        }
        HotAirBalloon hotAirBalloon = null;
        SphericalBody sphericalBody = null;
        if (collidableBody instanceof HotAirBalloon) {
            hotAirBalloon = (HotAirBalloon)collidableBody;
            if (collidableBody2 instanceof SphericalBody) {
                sphericalBody = (SphericalBody)collidableBody2;
            } else {
                throw new RuntimeException("bad arguments");
            }
        }
        if (collidableBody2 instanceof HotAirBalloon) {
            hotAirBalloon = (HotAirBalloon)collidableBody2;
            if (collidableBody instanceof SphericalBody) {
                sphericalBody = (SphericalBody)collidableBody;
            } else {
                throw new RuntimeException("bad arguments");
            }
        }
        if (hotAirBalloon == null || sphericalBody == null) {
            throw new RuntimeException("bad arguments");
        }
        if (!hotAirBalloon.getOpening().contains(sphericalBody.getPosition())) {
            bl = this.detector.areInContact(hotAirBalloon, sphericalBody);
        }
        return bl;
    }

    public boolean applies(CollidableBody collidableBody, CollidableBody collidableBody2) {
        return collidableBody instanceof HotAirBalloon && collidableBody2 instanceof SolidSphere || collidableBody instanceof SolidSphere && collidableBody2 instanceof HotAirBalloon;
    }
}

