/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.idealgas.collision;

import edu.colorado.phet.common.phetcommon.math.MathUtil;
import edu.colorado.phet.idealgas.collision.Collision;
import edu.colorado.phet.idealgas.collision.SphericalBody;
import edu.colorado.phet.idealgas.collision.Wall;
import edu.colorado.phet.idealgas.model.IdealGasModel;
import java.awt.geom.Rectangle2D;

public class SphereWallCollision
implements Collision {
    private SphericalBody sphere;
    private Wall wall;
    private IdealGasModel model;
    private int contactType;

    public SphereWallCollision(SphericalBody sphericalBody, Wall wall, int n, IdealGasModel idealGasModel) {
        this.sphere = sphericalBody;
        this.wall = wall;
        this.model = idealGasModel;
        this.contactType = n;
    }

    public void collide() {
        double d = this.sphere.getPosition().getX();
        double d2 = this.sphere.getPosition().getY();
        double d3 = this.sphere.getRadius();
        Rectangle2D rectangle2D = this.wall.getBounds();
        switch (this.contactType) {
            case 2: {
                this.sphere.setVelocity(-this.sphere.getVelocity().getX(), this.sphere.getVelocity().getY());
                double d4 = rectangle2D.getMaxX();
                double d5 = d4 - (d - d3);
                double d6 = d + d5 * 2.0;
                this.sphere.setPosition(d6, this.sphere.getPosition().getY());
                break;
            }
            case 1: {
                this.sphere.setVelocity(-this.sphere.getVelocity().getX(), this.sphere.getVelocity().getY());
                double d7 = rectangle2D.getMinX();
                double d8 = d + d3 - d7;
                double d9 = d - d8 * 2.0;
                this.sphere.setPosition(d9, this.sphere.getPosition().getY());
                break;
            }
            case 3: {
                this.sphere.setVelocity(this.sphere.getVelocity().getX(), -this.sphere.getVelocity().getY());
                double d10 = rectangle2D.getMinY();
                double d11 = d2 + d3 - d10;
                double d12 = d2 - d11 * 2.0;
                this.sphere.setPosition(this.sphere.getPosition().getX(), d12);
                this.adjustDyForGravity(d11 * 2.0);
                break;
            }
            case 4: {
                this.sphere.setVelocity(this.sphere.getVelocity().getX(), -this.sphere.getVelocity().getY());
                double d13 = rectangle2D.getMaxY();
                double d14 = d13 - (d2 - d3);
                double d15 = d2 + d14 * 2.0;
                this.sphere.setPosition(this.sphere.getPosition().getX(), d15);
                this.adjustDyForGravity(d14 * 2.0);
                break;
            }
            default: {
                throw new RuntimeException("Invalid contact type");
            }
        }
    }

    private void adjustDyForGravity(double d) {
        double d2 = this.sphere.getMass();
        double d3 = this.model.getGravity().getAmt();
        double d4 = this.sphere.getMass() * this.sphere.getVelocity().getY() * this.sphere.getVelocity().getY() / 2.0;
        double d5 = d * d3 * this.sphere.getMass();
        double d6 = 0.0;
        if (d4 >= d5) {
            d6 = Math.sqrt(2.0 / d2 * (d4 - d5)) * (double)MathUtil.getSign(this.sphere.getVelocity().getY());
            this.sphere.setVelocity(this.sphere.getVelocity().getX(), d6);
        }
    }
}

