/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.idealgas.controller;

import edu.colorado.phet.common.phetcommon.application.PhetApplication;
import edu.colorado.phet.common.phetcommon.util.EventChannel;
import edu.colorado.phet.common.phetcommon.view.ControlPanel;
import edu.colorado.phet.common.phetcommon.view.util.MakeDuotoneImageOp;
import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import edu.colorado.phet.common.phetgraphics.application.PhetGraphicsModule;
import edu.colorado.phet.common.phetgraphics.view.help.HelpItem;
import edu.colorado.phet.common.phetgraphics.view.phetcomponents.PhetJComponent;
import edu.colorado.phet.common.phetgraphics.view.phetgraphics.PhetGraphic;
import edu.colorado.phet.common.phetgraphics.view.phetgraphics.PhetImageGraphic;
import edu.colorado.phet.idealgas.IdealGasConfig;
import edu.colorado.phet.idealgas.IdealGasResources;
import edu.colorado.phet.idealgas.collision.SphereBoxExpert;
import edu.colorado.phet.idealgas.collision.SphereSphereExpert;
import edu.colorado.phet.idealgas.controller.IdealGasControlPanel;
import edu.colorado.phet.idealgas.controller.IdealGasThermometer;
import edu.colorado.phet.idealgas.controller.PumpSpeciesSelectorPanel;
import edu.colorado.phet.idealgas.controller.StoveControlPanel;
import edu.colorado.phet.idealgas.coreadditions.StopwatchPanel;
import edu.colorado.phet.idealgas.instrumentation.Thermometer;
import edu.colorado.phet.idealgas.model.GasMolecule;
import edu.colorado.phet.idealgas.model.Gravity;
import edu.colorado.phet.idealgas.model.IdealGasClock;
import edu.colorado.phet.idealgas.model.IdealGasModel;
import edu.colorado.phet.idealgas.model.PressureSensingBox;
import edu.colorado.phet.idealgas.model.PressureSlice;
import edu.colorado.phet.idealgas.model.Pump;
import edu.colorado.phet.idealgas.view.BaseIdealGasApparatusPanel;
import edu.colorado.phet.idealgas.view.Box2DGraphic;
import edu.colorado.phet.idealgas.view.BoxDoorGraphic;
import edu.colorado.phet.idealgas.view.Mannequin;
import edu.colorado.phet.idealgas.view.PumpHandleGraphic;
import edu.colorado.phet.idealgas.view.RulerGraphic;
import edu.colorado.phet.idealgas.view.WiggleMeGraphic;
import edu.colorado.phet.idealgas.view.monitors.CmLines;
import edu.colorado.phet.idealgas.view.monitors.EnergyHistogramDialog;
import edu.colorado.phet.idealgas.view.monitors.PressureDialGauge;
import edu.colorado.phet.idealgas.view.monitors.PressureSliceGraphic;
import edu.colorado.phet.idealgas.view.monitors.SpeciesMonitorDialog;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.EventObject;
import java.util.List;
import java.util.Random;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;

public class IdealGasModule
extends PhetGraphicsModule {
    private static BufferedImage basePumpImg = IdealGasResources.getImage("pump-body.png");
    private static BufferedImage bluePumpImg;
    private static BufferedImage redPumpImg;
    protected static WiggleMeGraphic wiggleMeGraphic;
    private static BufferedImage pumpBaseAndHoseImg;
    private static BufferedImage handleImg;
    private IdealGasModel idealGasModel;
    private PressureSensingBox box;
    private Gravity gravity;
    private Pump pump;
    private CmLines cmLines;
    private PressureSlice pressureSlice;
    private IdealGasClock clock;
    private PressureSliceGraphic pressureSliceGraphic;
    private PhetGraphic rulerGraphic;
    private EnergyHistogramDialog histogramDlg;
    private ArrayList visibleInstruments = new ArrayList();
    private JDialog speciesMonitorDlg;
    private IdealGasControlPanel idealGasControlPanel;
    private Thermometer thermometer;
    private PhetImageGraphic pumpGraphic;
    private Box2DGraphic boxGraphic;
    private JPanel pressureSlideTimeAveCtrlPane;
    private StopwatchPanel stopwatchPanel;
    private Mannequin pusher;
    private BoxDoorGraphic boxDoorGraphic;
    private PumpHandleGraphic pumpHandleGraphic;
    private PumpSpeciesSelectorPanel pumpSelectorPanel;
    private PhetImageGraphic pumpBaseAndHoseGraphic;
    private double xOrigin = 162.0;
    private double yOrigin = 152.0;
    private double xDiag = 464.0;
    private double yDiag = 397.0;
    private Color boxColor = new Color(180, 180, 180);
    private Random random = new Random();
    private PressureDialGauge pressureGauge;
    private PhetGraphic returnLidGraphic;
    EventChannel resetEventChannel = new EventChannel(ResetListener.class);
    ResetListener resetListenersProxy = (ResetListener)this.resetEventChannel.getListenerProxy();

    public IdealGasModule(IdealGasClock idealGasClock) {
        this(idealGasClock, IdealGasResources.getString("ModuleTitle.IdealGas"));
        this.clock = idealGasClock;
    }

    public IdealGasModule(IdealGasClock idealGasClock, String string) {
        this(idealGasClock, string, new IdealGasModel(idealGasClock.getDt()));
    }

    protected IdealGasModule(IdealGasClock idealGasClock, String string, IdealGasModel idealGasModel) {
        super(string, idealGasClock);
        this.clock = idealGasClock;
        this.idealGasModel = idealGasModel;
        this.setModel(this.idealGasModel);
        this.idealGasModel.addCollisionExpert(new SphereSphereExpert(this.idealGasModel, idealGasClock.getDt()));
        this.idealGasModel.addCollisionExpert(new SphereBoxExpert(this.idealGasModel));
        this.createBoxAndGraphic(idealGasClock);
        this.getApparatusPanel().addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent componentEvent) {
                IdealGasModule.this.idealGasModel.setModelBounds();
            }
        });
        this.getApparatusPanel().setDisplayBorder(true);
        this.createGauges(idealGasClock);
        this.createPumpAndGraphic();
        this.gravity = new Gravity(this.idealGasModel);
        this.setGravity(0.0);
        this.idealGasModel.addModelElement(this.gravity);
        this.pusher = new Mannequin(this.getApparatusPanel(), this.idealGasModel, this.box, this.boxGraphic);
        this.addGraphic(this.pusher, 10.0);
        this.idealGasControlPanel = new IdealGasControlPanel(this);
        ControlPanel controlPanel = new ControlPanel(this);
        controlPanel.addControl(this.idealGasControlPanel);
        this.setControlPanel(controlPanel);
        this.createApparatusSwingControls();
        this.createReturnLidButton();
        this.addHelp();
    }

    protected IdealGasModel getIdealGasModel() {
        return (IdealGasModel)this.getModel();
    }

    protected String[] getSpeciesNames() {
        return new String[]{IdealGasResources.getString("Common.Heavy_Species"), IdealGasResources.getString("Common.Light_Species")};
    }

    private void createGauges(IdealGasClock idealGasClock) {
        PressureSlice pressureSlice = new PressureSlice(this.box, this.idealGasModel, idealGasClock);
        pressureSlice.setTimeAveragingWindow(2500.0 * (idealGasClock.getDt() / (double)idealGasClock.getDelay()));
        pressureSlice.setUpdateContinuously(true);
        pressureSlice.setY(this.box.getMinY() + 50.0);
        this.box.setGaugeSlice(pressureSlice);
        this.idealGasModel.addModelElement(pressureSlice);
        this.pressureGauge = new PressureDialGauge(this.box, this.getApparatusPanel(), new Point((int)this.box.getMaxX(), (int)pressureSlice.getY()));
        this.addGraphic(this.pressureGauge, 10.0);
        double d = 100.0;
        Point2D.Double double_ = new Point2D.Double(this.box.getMaxX() - 30.0, this.box.getMinY() - d);
        this.thermometer = new IdealGasThermometer(this.getApparatusPanel(), this.idealGasModel, double_, d, 10.0, true, 0.0, 1000000.0);
        this.addGraphic(this.thermometer, 10.1);
    }

    private void createBoxAndGraphic(IdealGasClock idealGasClock) {
        this.box = new PressureSensingBox(new Point2D.Double(this.xOrigin, this.yOrigin), new Point2D.Double(this.xDiag, this.yDiag), this.idealGasModel, idealGasClock);
        this.idealGasModel.addBox(this.box);
        this.setApparatusPanel(new BaseIdealGasApparatusPanel(this, idealGasClock, this.box));
        this.boxGraphic = new Box2DGraphic(this.getApparatusPanel(), this.box, this.boxColor);
        this.addGraphic(this.boxGraphic, 10.0);
        this.boxDoorGraphic = new BoxDoorGraphic(this.getApparatusPanel(), 260, -78, 180, 120, 260, 120, this.box, this.boxColor, this);
        this.addGraphic(this.boxDoorGraphic, 11.0);
    }

    private void createApparatusSwingControls() {
        StoveControlPanel stoveControlPanel = new StoveControlPanel(this);
        stoveControlPanel.setLocation(377, 435);
        this.getApparatusPanel().addGraphic(stoveControlPanel);
        this.pumpSelectorPanel = new PumpSpeciesSelectorPanel(this);
        this.pumpSelectorPanel.setLocation(660, 200);
        this.pumpSelectorPanel.setLocation((int)(this.pumpGraphic.getLocation().getX() + (double)this.pumpGraphic.getWidth() - (double)this.pumpSelectorPanel.getWidth() + 10.0), (int)(this.pumpGraphic.getLocation().getY() + (double)this.pumpGraphic.getHeight() + 32.0));
        this.getApparatusPanel().addGraphic(this.pumpSelectorPanel);
        this.getApparatusPanel().revalidate();
    }

    private void createReturnLidButton() {
        JButton jButton = new JButton(IdealGasResources.getString("returnLid")){
            {
                this.setFont(new PhetFont(18));
                this.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        IdealGasModule.this.resetChamber();
                    }
                });
            }
        };
        this.returnLidGraphic = PhetJComponent.newInstance(this.getApparatusPanel(), jButton);
        this.returnLidGraphic.setVisible(!this.box.isPressureSafe());
        this.getApparatusPanel().addGraphic(this.returnLidGraphic);
        this.returnLidGraphic.setLocation(250 - this.returnLidGraphic.getWidth(), 130 - this.returnLidGraphic.getHeight());
        this.box.addChangeListener(new PressureSensingBox.ChangeListener(){

            public void stateChanged(PressureSensingBox.ChangeEvent changeEvent) {
                if (!IdealGasModule.this.box.isPressureSafe()) {
                    IdealGasModule.this.returnLidGraphic.setVisible(true);
                }
            }
        });
    }

    private void createPumpAndGraphic() {
        this.pump = new Pump(this, this.box, this.getPumpingEnergyStrategy());
        PhetImageGraphic phetImageGraphic = new PhetImageGraphic(this.getApparatusPanel(), handleImg);
        this.pumpHandleGraphic = new PumpHandleGraphic(this.getApparatusPanel(), this.pump, phetImageGraphic, 608, 138, 608, 0, 608, 138);
        BufferedImage bufferedImage = bluePumpImg;
        this.addGraphic(this.pumpHandleGraphic, -6.0);
        this.pumpBaseAndHoseGraphic = new PhetImageGraphic(this.getApparatusPanel(), pumpBaseAndHoseImg, 466, 158);
        this.pumpGraphic = new PhetImageGraphic(this.getApparatusPanel(), bufferedImage, 466, 158);
        this.pumpGraphic.setRenderingHints(new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON));
        this.addGraphic(this.pumpGraphic, -4.0);
        this.addGraphic(this.pumpBaseAndHoseGraphic, -3.5);
    }

    protected void removePumpGraphic() {
        this.getApparatusPanel().removeGraphic(this.pumpGraphic);
        this.getApparatusPanel().removeGraphic(this.pumpHandleGraphic);
        this.getApparatusPanel().removeGraphic(this.pumpSelectorPanel);
        this.getApparatusPanel().removeGraphic(this.pumpBaseAndHoseGraphic);
    }

    protected Pump.PumpingEnergyStrategy getPumpingEnergyStrategy() {
        return new Pump.ConstantEnergyStrategy(this.idealGasModel);
    }

    protected void addHelp() {
        this.addWallHelp();
        this.addDoorHelp();
        this.addStoveHelp();
    }

    protected void addStoveHelp() {
        HelpItem helpItem = new HelpItem(this.getApparatusPanel(), IdealGasResources.getString("help.stove"), this.box.getPosition().getX() + 50.0, this.box.getMaxY() + 50.0);
        helpItem.setForegroundColor(IdealGasConfig.HELP_COLOR);
        this.addHelpItem(helpItem);
    }

    protected void addDoorHelp() {
        HelpItem helpItem = new HelpItem(this.getApparatusPanel(), IdealGasResources.getString("help.door"), this.box.getPosition().getX() + 100.0, this.box.getPosition().getY() - 50.0);
        helpItem.setForegroundColor(IdealGasConfig.HELP_COLOR);
        this.addHelpItem(helpItem);
    }

    protected void addWallHelp() {
        HelpItem helpItem = new HelpItem(this.getApparatusPanel(), IdealGasResources.getString("help.wall"), this.box.getPosition().getX(), this.box.getPosition().getY(), 2, 3);
        helpItem.setForegroundColor(IdealGasConfig.HELP_COLOR);
        this.addHelpItem(helpItem);
    }

    protected IdealGasControlPanel getIdealGasControlPanel() {
        return this.idealGasControlPanel;
    }

    public int getHeavySpeciesCnt() {
        return this.idealGasModel.getHeavySpeciesCnt();
    }

    public int getLightSpeciesCnt() {
        return this.idealGasModel.getLightSpeciesCnt();
    }

    public JDialog setSpeciesMonitorDlgEnabled(boolean bl) {
        if (this.speciesMonitorDlg == null) {
            this.speciesMonitorDlg = new SpeciesMonitorDialog(PhetApplication.getInstance().getPhetFrame(), this.idealGasModel);
        }
        this.speciesMonitorDlg.setVisible(bl);
        if (bl) {
            this.visibleInstruments.add(this.speciesMonitorDlg);
        } else {
            this.visibleInstruments.remove(this.speciesMonitorDlg);
        }
        return this.speciesMonitorDlg;
    }

    public void setCmLinesOn(boolean bl) {
        if (this.cmLines == null) {
            this.cmLines = new CmLines(this.getApparatusPanel(), this.idealGasModel);
        }
        if (bl) {
            this.addGraphic(this.cmLines, 11.0);
        } else {
            this.getApparatusPanel().removeGraphic(this.cmLines);
        }
    }

    public void setStove(int n) {
        this.idealGasModel.setHeatSource(n);
        ((BaseIdealGasApparatusPanel)this.getApparatusPanel()).setStove(n);
    }

    public void setGravity(double d) {
        this.gravity.setAmt(d);
        if (d != 0.0) {
            this.pump.setPumpingEnergyStrategy(new Pump.FixedEnergyStrategy());
            this.box.setMultipleSlicesEnabled(false);
        } else {
            this.pump.setPumpingEnergyStrategy(new Pump.ConstantEnergyStrategy(this.getIdealGasModel()));
            this.box.setMultipleSlicesEnabled(true);
        }
    }

    public void pumpGasMolecules(int n, Class clazz) {
        this.pump.pump(n, clazz);
    }

    public void removeGasMolecule(Class clazz) {
        List list = this.idealGasModel.getBodies();
        Object var3_3 = null;
        while (var3_3 == null) {
            int n;
            boolean bl = this.random.nextBoolean();
            if (bl) {
                for (n = 0; n < list.size() && !clazz.isInstance(var3_3 = list.get(n)); ++n) {
                }
                continue;
            }
            for (n = list.size() - 1; n >= 0 && !clazz.isInstance(var3_3 = list.get(n)); --n) {
            }
        }
        if (var3_3 instanceof GasMolecule) {
            GasMolecule gasMolecule = var3_3;
            this.idealGasModel.removeModelElement(gasMolecule);
        }
    }

    protected PressureSensingBox getBox() {
        return this.box;
    }

    protected Box2DGraphic getBoxGraphic() {
        return this.boxGraphic;
    }

    protected BoxDoorGraphic getBoxDoorGraphic() {
        return this.boxDoorGraphic;
    }

    public Mannequin getPusher() {
        return this.pusher;
    }

    public Pump getPump() {
        return this.pump;
    }

    public Thermometer getThermometer() {
        return this.thermometer;
    }

    protected StopwatchPanel getStopwatchPanel() {
        return this.stopwatchPanel;
    }

    public void setPressureSliceEnabled(boolean bl) {
        if (this.pressureSlice == null) {
            this.pressureSlice = new PressureSlice(this.getBox(), (IdealGasModel)this.getModel(), this.clock);
            this.pressureSlice.setUpdateContinuously(false);
            this.pressureSliceGraphic = new PressureSliceGraphic(this.getApparatusPanel(), this.pressureSlice, this.getBox());
            DecimalFormat decimalFormat = new DecimalFormat("#.0");
            final double d = this.clock.getDt() / (double)this.clock.getDelay();
            final JTextField jTextField = new JTextField(3);
            jTextField.setHorizontalAlignment(4);
            jTextField.setText(decimalFormat.format(this.pressureSlice.getTimeAveragingWindow() / (1000.0 * d)));
            jTextField.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    double d3 = Double.parseDouble(jTextField.getText()) * 1000.0;
                    double d2 = d3 * d;
                    IdealGasModule.this.pressureSlice.setTimeAveragingWindow(d2);
                }
            });
            JButton jButton = new JButton(IdealGasResources.getString("IdealGasControlPanel.SetButton"));
            jButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    double d3 = Double.parseDouble(jTextField.getText()) * 1000.0;
                    double d2 = d3 * d;
                    IdealGasModule.this.pressureSlice.setTimeAveragingWindow(d2);
                }
            });
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new GridBagLayout());
            GridBagConstraints gridBagConstraints = new GridBagConstraints(-1, 0, 1, 1, 1.0, 1.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0);
            jPanel.add((Component)jTextField, gridBagConstraints);
            jPanel.add((Component)new JLabel(IdealGasResources.getString("IdealGasModule.StopwatchTimeUnits")), gridBagConstraints);
            gridBagConstraints.insets = new Insets(0, 10, 0, 0);
            jPanel.add((Component)jButton, gridBagConstraints);
            TitledBorder titledBorder = new TitledBorder(new EtchedBorder(0, new Color(40, 20, 255), Color.black), IdealGasResources.getString("IdealGasControlPanel.AveTimePanelTitle"));
            jPanel.setBorder(titledBorder);
            Color color = new Color(240, 230, 255);
            jPanel.setBackground(color);
            this.pressureSlideTimeAveCtrlPane = new JPanel();
            this.pressureSlideTimeAveCtrlPane.setOpaque(false);
            this.pressureSlideTimeAveCtrlPane.add(jPanel);
            this.pressureSlideTimeAveCtrlPane.setBounds(15, 15, 200, 100);
            this.getApparatusPanel().add(this.pressureSlideTimeAveCtrlPane);
        }
        if (bl) {
            this.getModel().addModelElement(this.pressureSlice);
            this.addGraphic(this.pressureSliceGraphic, 20.0);
            this.pressureSlideTimeAveCtrlPane.setVisible(true);
            this.getApparatusPanel().revalidate();
        } else {
            this.getApparatusPanel().removeGraphic(this.pressureSliceGraphic);
            this.getModel().removeModelElement(this.pressureSlice);
            if (this.pressureSlideTimeAveCtrlPane != null) {
                this.pressureSlideTimeAveCtrlPane.setVisible(false);
            }
        }
    }

    public void setRulerEnabed(boolean bl) {
        if (this.rulerGraphic == null) {
            this.rulerGraphic = new RulerGraphic(this.getApparatusPanel());
        }
        if (bl) {
            this.getApparatusPanel().addGraphic(this.rulerGraphic, 2.147483647E9);
        } else {
            this.getApparatusPanel().removeGraphic(this.rulerGraphic);
        }
        this.getApparatusPanel().revalidate();
        this.getApparatusPanel().paintImmediately(0, 0, (int)this.getApparatusPanel().getBounds().getWidth(), (int)this.getApparatusPanel().getBounds().getHeight());
    }

    public JDialog setHistogramDlgEnabled(boolean bl) {
        if (bl) {
            this.visibleInstruments.add(this.histogramDlg);
            this.histogramDlg = new EnergyHistogramDialog((Frame)PhetApplication.getInstance().getPhetFrame(), (IdealGasModel)this.getModel());
            this.histogramDlg.setVisible(true);
        } else {
            this.histogramDlg.setVisible(false);
            this.histogramDlg = null;
            this.visibleInstruments.remove(this.histogramDlg);
        }
        return this.histogramDlg;
    }

    public void setStopwatchEnabled(boolean bl) {
        if (bl) {
            this.stopwatchPanel = new StopwatchPanel(this.getModel(), IdealGasResources.getString("stopwatch.units"), 1.71);
            this.getClockControlPanel().add((Component)this.stopwatchPanel, "West");
            this.getClockControlPanel().revalidate();
            this.visibleInstruments.add(this.stopwatchPanel);
        } else {
            this.getClockControlPanel().remove(this.stopwatchPanel);
            this.getClockControlPanel().revalidate();
            this.visibleInstruments.remove(this.stopwatchPanel);
        }
    }

    public void setPressureGaugeVisible(boolean bl) {
        if (bl) {
            this.getApparatusPanel().addGraphic(this.pressureGauge);
        } else {
            this.getApparatusPanel().removeGraphic(this.pressureGauge);
        }
    }

    public void reset() {
        this.resetChamber();
        this.box.setBounds(this.xOrigin, this.yOrigin, this.xDiag, this.yDiag);
        this.resetListenersProxy.resetOccurred(new ResetEvent(this));
        if (this.stopwatchPanel != null) {
            this.stopwatchPanel.reset();
        }
    }

    protected void resetChamber() {
        this.getIdealGasModel().removeAllMolecules();
        this.idealGasControlPanel.resetSpeciesControls();
        this.box.setOpening(new Point2D[]{new Point2D.Double(), new Point2D.Double()});
        this.box.clearData();
        this.boxDoorGraphic.closeDoor();
        this.returnLidGraphic.setVisible(false);
    }

    public void addResetListener(ResetListener resetListener) {
        this.resetEventChannel.addListener(resetListener);
    }

    public void setCurrentPumpImage(Color color) {
        if (color.equals(Color.blue)) {
            this.pumpGraphic.setImage(bluePumpImg);
        }
        if (color.equals(Color.red)) {
            this.pumpGraphic.setImage(redPumpImg);
        }
    }

    static {
        pumpBaseAndHoseImg = IdealGasResources.getImage("pump-base-and-hose.png");
        handleImg = IdealGasResources.getImage("pump-handle.png");
        bluePumpImg = new BufferedImage(basePumpImg.getWidth(), basePumpImg.getHeight(), 2);
        redPumpImg = new BufferedImage(basePumpImg.getWidth(), basePumpImg.getHeight(), 2);
        MakeDuotoneImageOp makeDuotoneImageOp = new MakeDuotoneImageOp(Color.blue);
        makeDuotoneImageOp.filter(basePumpImg, bluePumpImg);
        MakeDuotoneImageOp makeDuotoneImageOp2 = new MakeDuotoneImageOp(Color.red);
        makeDuotoneImageOp2.filter(basePumpImg, redPumpImg);
    }

    public class ResetEvent
    extends EventObject {
        public ResetEvent(Object object) {
            super(object);
        }
    }

    public static interface ResetListener
    extends EventListener {
        public void resetOccurred(ResetEvent var1);
    }
}

