/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.idealgas.controller;

import edu.colorado.phet.idealgas.IdealGasResources;
import edu.colorado.phet.idealgas.controller.IdealGasModule;
import edu.colorado.phet.idealgas.model.Pump;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class InputTemperatureControlPanel
extends JPanel {
    private final IdealGasModule module;
    private final Pump[] pumps;
    private final JCheckBox temperatureCheckBox;
    private final JSpinner temperatureSpinner;

    public InputTemperatureControlPanel(IdealGasModule idealGasModule, Pump[] pumpArray) {
        super(new GridBagLayout());
        this.module = idealGasModule;
        this.pumps = pumpArray;
        this.temperatureCheckBox = new JCheckBox(IdealGasResources.getString("AdvancedControlPanel.Particle_Temperature"), false);
        this.temperatureCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                InputTemperatureControlPanel.this.temperatureSpinner.setEnabled(InputTemperatureControlPanel.this.temperatureCheckBox.isSelected());
                InputTemperatureControlPanel.this.updatePumps();
            }
        });
        this.temperatureSpinner = new JSpinner(new SpinnerNumberModel(300.0, 50.0, 10000.0, 1.0));
        this.temperatureSpinner.setEnabled(false);
        this.temperatureSpinner.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                InputTemperatureControlPanel.this.updatePumps();
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0);
        gridBagConstraints.anchor = 18;
        this.add((Component)this.temperatureCheckBox, gridBagConstraints);
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 10;
        this.add((Component)this.temperatureSpinner, gridBagConstraints);
    }

    private double getTemperature() {
        return (Double)this.temperatureSpinner.getValue() * 20.0 * 2.5;
    }

    private Pump.PumpingEnergyStrategy getPumpingStrategy() {
        Pump.PumpingEnergyStrategy pumpingEnergyStrategy = null;
        pumpingEnergyStrategy = this.temperatureCheckBox.isSelected() ? new Pump.FixedEnergyStrategy(this.getTemperature()) : this.module.getPumpingEnergyStrategy();
        return pumpingEnergyStrategy;
    }

    private void updatePumps() {
        Pump.PumpingEnergyStrategy pumpingEnergyStrategy = this.getPumpingStrategy();
        System.out.println("updating " + this.pumps.length + " pumps, energy=" + pumpingEnergyStrategy.getMoleculeEnergy() + " type=" + pumpingEnergyStrategy.getClass().getName());
        for (int i = 0; i < this.pumps.length; ++i) {
            this.pumps[i].setPumpingEnergyStrategy(pumpingEnergyStrategy);
        }
    }
}

