/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.idealgas.controller;

import edu.colorado.phet.common.phetcommon.math.vector.MutableVector2D;
import edu.colorado.phet.idealgas.IdealGasResources;
import edu.colorado.phet.idealgas.controller.IdealGasModule;
import edu.colorado.phet.idealgas.controller.PumpControlPanel;
import edu.colorado.phet.idealgas.controller.command.PumpMoleculeCmd;
import edu.colorado.phet.idealgas.model.HeavySpecies;
import edu.colorado.phet.idealgas.model.IdealGasModel;
import edu.colorado.phet.idealgas.model.LightSpecies;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Point2D;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public abstract class SpeciesSelectionPanel
extends JPanel
implements IdealGasModule.ResetListener {
    private static final Dimension PREFERRED_SPINNER_SIZE = new Dimension(70, 20);
    private IdealGasModule module;
    private MoleculeCountSpinner heavySpinner;
    private MoleculeCountSpinner lightSpinner;
    private JLabel heavySpeciesLbl;
    private JLabel lightSpeciesLbl;

    public SpeciesSelectionPanel(IdealGasModule idealGasModule) {
        this(idealGasModule, new String[]{IdealGasResources.getString("Common.Heavy_Species"), IdealGasResources.getString("Common.Light_Species")});
    }

    public SpeciesSelectionPanel(final IdealGasModule idealGasModule, String[] stringArray) {
        this.module = idealGasModule;
        idealGasModule.addResetListener(this);
        this.makeLabels(stringArray);
        this.makeSpinners();
        this.setLayout(new GridBagLayout());
        Insets insets = new Insets(0, 0, 0, 0);
        GridBagConstraints gridBagConstraints = new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 13, 0, insets, 0, 0);
        this.add((Component)this.heavySpeciesLbl, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.anchor = 17;
        this.add((Component)this.heavySpinner, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 13;
        this.add((Component)this.lightSpeciesLbl, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.anchor = 17;
        this.add((Component)this.lightSpinner, gridBagConstraints);
        boolean bl = false;
        if (bl) {
            JButton jButton = new JButton("Test");
            jButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    HeavySpecies heavySpecies = new HeavySpecies(new Point2D.Double(idealGasModule.getBox().getPosition().getX() + 300.0, idealGasModule.getBox().getPosition().getY() + 30.0), new MutableVector2D(-53.0, -20.0), new MutableVector2D());
                    new PumpMoleculeCmd((IdealGasModel)idealGasModule.getModel(), heavySpecies, idealGasModule).doIt();
                    SpeciesSelectionPanel.this.heavySpinner.setValue(new Integer(1));
                    ((PumpControlPanel)SpeciesSelectionPanel.this).moleculeAdded(heavySpecies);
                }
            });
            ++gridBagConstraints.gridy;
            this.add((Component)jButton, gridBagConstraints);
        }
    }

    private void makeLabels(String[] stringArray) {
        this.heavySpeciesLbl = new JLabel(stringArray[0]);
        this.heavySpeciesLbl.setForeground(Color.blue);
        this.lightSpeciesLbl = new JLabel(stringArray[1]);
        this.lightSpeciesLbl.setForeground(Color.red);
    }

    private void makeSpinners() {
        Integer n = new Integer(0);
        Integer n2 = new Integer(0);
        Integer n3 = new Integer(1000);
        Integer n4 = new Integer(1);
        SpinnerNumberModel spinnerNumberModel = new SpinnerNumberModel(n, n2, n3, n4);
        this.heavySpinner = new MoleculeCountSpinner(spinnerNumberModel, new IntegerValue(){

            public int getValue() {
                return SpeciesSelectionPanel.this.getHeavySpeciesCnt();
            }
        });
        this.heavySpinner.setPreferredSize(PREFERRED_SPINNER_SIZE);
        this.heavySpinner.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                block2: {
                    int n;
                    block3: {
                        if (!SpeciesSelectionPanel.this.heavySpinner.isEnabled()) break block2;
                        n = (Integer)SpeciesSelectionPanel.this.heavySpinner.getValue() - SpeciesSelectionPanel.this.getHeavySpeciesCnt();
                        if (n <= 0) break block3;
                        for (int i = 0; i < n; ++i) {
                            SpeciesSelectionPanel.this.createMolecule(HeavySpecies.class);
                        }
                        break block2;
                    }
                    if (n >= 0) break block2;
                    for (int i = 0; i < -n; ++i) {
                        SpeciesSelectionPanel.this.removeMolecule(HeavySpecies.class);
                    }
                }
            }
        });
        SpinnerNumberModel spinnerNumberModel2 = new SpinnerNumberModel(n, n2, n3, n4);
        this.lightSpinner = new MoleculeCountSpinner(spinnerNumberModel2, new IntegerValue(){

            public int getValue() {
                return SpeciesSelectionPanel.this.getLightSpeciesCnt();
            }
        });
        this.lightSpinner.setPreferredSize(PREFERRED_SPINNER_SIZE);
        this.lightSpinner.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                block2: {
                    int n;
                    block3: {
                        if (!SpeciesSelectionPanel.this.lightSpinner.isEnabled()) break block2;
                        n = (Integer)SpeciesSelectionPanel.this.lightSpinner.getValue() - SpeciesSelectionPanel.this.getLightSpeciesCnt();
                        if (n <= 0) break block3;
                        for (int i = 0; i < n; ++i) {
                            SpeciesSelectionPanel.this.createMolecule(LightSpecies.class);
                        }
                        break block2;
                    }
                    if (n >= 0) break block2;
                    for (int i = 0; i < -n; ++i) {
                        SpeciesSelectionPanel.this.removeMolecule(LightSpecies.class);
                    }
                }
            }
        });
    }

    public void resetOccurred(IdealGasModule.ResetEvent resetEvent) {
        this.reset();
    }

    public void reset() {
        this.heavySpinner.setEnabled(false);
        this.lightSpinner.setEnabled(false);
        this.heavySpinner.setValue(new Integer(0));
        this.lightSpinner.setValue(new Integer(0));
        this.heavySpinner.setEnabled(true);
        this.lightSpinner.setEnabled(true);
    }

    protected IdealGasModule getModule() {
        return this.module;
    }

    public MoleculeCountSpinner getHeavySpinner() {
        return this.heavySpinner;
    }

    public MoleculeCountSpinner getLightSpinner() {
        return this.lightSpinner;
    }

    public void setHeavySpeciesLabelText(String string) {
        this.heavySpeciesLbl.setText(string);
    }

    public void setLightSpeciesLabelText(String string) {
        this.lightSpeciesLbl.setText(string);
    }

    public void setHeavySpeciesLabelColor(Color color) {
        this.heavySpeciesLbl.setForeground(color);
    }

    public void setLightSpeciesLabelColor(Color color) {
        this.lightSpeciesLbl.setForeground(color);
    }

    protected abstract void createMolecule(Class var1);

    protected abstract void removeMolecule(Class var1);

    protected abstract int getHeavySpeciesCnt();

    protected abstract int getLightSpeciesCnt();

    public static interface IntegerValue {
        public int getValue();
    }

    public class MoleculeCountSpinner
    extends JSpinner {
        private IntegerValue value;

        public MoleculeCountSpinner(SpinnerModel spinnerModel, IntegerValue integerValue) {
            super(spinnerModel);
            this.value = integerValue;
        }

        public void updateValue() {
            this.setValue(new Integer(this.value.getValue()));
        }
    }
}

