/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.idealgas.instrumentation;

import edu.colorado.phet.idealgas.instrumentation.HistogramModel;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import javax.swing.JPanel;

public class Histogram
extends JPanel {
    private HistogramModel model;
    private int bucketWidth = 20;
    private int displayWidth = 300;
    private int displayHeight = 200;
    private int clippingLevel;
    private Color color;
    private Point plotULC = new Point(10, 10);
    private int maxBuckHeight;

    public Histogram(int n, int n2, double d, double d2, int n3, int n4, Color color) {
        this.displayWidth = n;
        this.displayHeight = n2;
        this.clippingLevel = n4;
        this.model = new HistogramModel();
        this.model.setBounds(d, d2);
        this.model.setNumIntervals(n3);
        this.color = color;
        this.bucketWidth = n / this.model.getNumIntervals();
        this.maxBuckHeight = n2;
        this.setPreferredSize(new Dimension(this.plotULC.x * 2 + n, this.plotULC.y * 2 + n2));
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public void paintComponent(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setColor(Color.WHITE);
        graphics2D.fillRect(this.plotULC.x, this.plotULC.y, this.displayWidth, this.displayHeight);
        int n = 20;
        int n2 = this.displayHeight / n;
        graphics2D.setColor(new Color(230, 230, 230));
        graphics2D.setStroke(new BasicStroke(1.0f));
        int n3 = this.displayHeight + this.plotULC.y;
        int n4 = 0;
        while (n3 > this.plotULC.y) {
            n3 = this.displayHeight + this.plotULC.y - n * n4 * this.maxBuckHeight / this.clippingLevel;
            graphics2D.drawLine(this.plotULC.x, n3, this.plotULC.x + this.displayWidth, n3);
            ++n4;
        }
        graphics2D.setColor(this.color);
        for (n4 = 0; n4 < this.model.getNumIntervals(); ++n4) {
            int n5 = this.model.valueAt(n4);
            int n6 = Math.min(n5 * this.maxBuckHeight / this.clippingLevel, this.maxBuckHeight);
            int n7 = this.displayHeight + this.plotULC.y - n6;
            int n8 = this.displayHeight + this.plotULC.y;
            graphics2D.fillRect(this.plotULC.x + n4 * this.bucketWidth, this.displayHeight + this.plotULC.y - n6, this.bucketWidth, n6);
        }
        graphics2D.setColor(Color.BLACK);
        graphics2D.drawRect(this.plotULC.x, this.plotULC.y, this.displayWidth - 1, this.displayHeight - 1);
    }

    public void add(double d) {
        int n = this.model.add(d);
        switch (n) {
            case 2: {
                break;
            }
        }
    }

    public void setClippingLevel(int n) {
        this.clippingLevel = n;
    }

    public void clear() {
        this.model.clear();
    }

    public boolean hasDataOutOfRange() {
        return this.model.isDataOutOfRange();
    }
}

