/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.idealgas.instrumentation;

import java.util.ArrayList;
import java.util.TreeMap;

public class HistogramModel {
    private double lowerBound;
    private double upperBound;
    private TreeMap data = new TreeMap();
    private int numBuckets;
    private double interval;
    private ArrayList buckets = new ArrayList();
    private boolean dataOutOfRange;

    public void setBounds(double d, double d2) {
        this.lowerBound = d;
        this.upperBound = d2;
    }

    public void setNumIntervals(int n) {
        this.numBuckets = n;
        this.interval = (this.upperBound - this.lowerBound) / (double)n;
        this.createBuckets();
    }

    private void createBuckets() {
        this.buckets.clear();
        for (double d = this.lowerBound; d < this.upperBound; d += this.interval) {
            this.buckets.add(new Bucket(d, d + this.interval));
        }
    }

    public void clear() {
        this.dataOutOfRange = false;
        for (int i = 0; i < this.buckets.size(); ++i) {
            Bucket bucket = (Bucket)this.buckets.get(i);
            bucket.setCount(0);
        }
    }

    public int add(double d) {
        int n = 1;
        Bucket bucket = this.findBucket(d);
        if (bucket != null) {
            bucket.increment();
            n = 1;
        } else if (d < ((Bucket)this.buckets.get(0)).lowerBound) {
            n = 2;
        } else if (d >= ((Bucket)this.buckets.get(this.buckets.size() - 1)).upperBound) {
            this.dataOutOfRange = true;
        }
        return n;
    }

    private Bucket findBucket(double d) {
        Bucket bucket = null;
        for (int i = 0; bucket == null && i < this.buckets.size(); ++i) {
            Bucket bucket2 = (Bucket)this.buckets.get(i);
            if (!(d >= bucket2.lowerBound) || !(d < bucket2.upperBound)) continue;
            bucket = bucket2;
        }
        return bucket;
    }

    public int valueAt(int n) {
        return ((Bucket)this.buckets.get(n)).getCount();
    }

    public int getNumIntervals() {
        return this.numBuckets;
    }

    public boolean isDataOutOfRange() {
        return this.dataOutOfRange;
    }

    private static class Bucket {
        private double lowerBound;
        private double upperBound;
        private int count;
        private static ArrayList s_instances = new ArrayList();

        Bucket(double d, double d2) {
            this.lowerBound = d;
            this.upperBound = d2;
            s_instances.add(this);
        }

        void increment() {
            ++this.count;
        }

        int getCount() {
            return this.count;
        }

        void setCount(int n) {
            this.count = 0;
        }
    }
}

