/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.idealgas.model;

import edu.colorado.phet.common.phetcommon.util.EventChannel;
import edu.colorado.phet.idealgas.collision.CollidableBody;
import edu.colorado.phet.idealgas.collision.SphericalBody;
import edu.colorado.phet.idealgas.model.GasMolecule;
import edu.colorado.phet.idealgas.model.IdealGasModel;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.EventListener;
import java.util.EventObject;

public class Box2D
extends CollidableBody {
    private Point2D corner1;
    private Point2D corner2;
    private Point2D center;
    private double minX;
    private double minY;
    private double maxX;
    private double maxY;
    private double leftWallVx = 0.0;
    private boolean autoNotify = true;
    private boolean volumeFixed = false;
    private Point2D[] opening = new Point2D.Double[]{new Point2D.Double(), new Point2D.Double()};
    IdealGasModel model;
    private double oldMinX;
    private double minimumWidth = 100.0;
    private Line2D openingLine;
    private EventChannel changeEventChannel = new EventChannel(ChangeListener.class);
    private ChangeListener changeListenerProxy = (ChangeListener)this.changeEventChannel.getListenerProxy();

    public Box2D(Point2D point2D, Point2D point2D2, IdealGasModel idealGasModel) {
        this.model = idealGasModel;
        this.setState(point2D, point2D2);
        this.oldMinX = Math.min(point2D.getX(), point2D2.getX());
        this.setMass(Double.POSITIVE_INFINITY);
        this.attachModelListener();
    }

    private void attachModelListener() {
        this.model.addChangeListener(new IdealGasModel.ChangeListener(){

            public void stateChanged(IdealGasModel.ChangeEvent changeEvent) {
                switch (changeEvent.getModel().getConstantProperty()) {
                    case 0: 
                    case 2: 
                    case 3: {
                        Box2D.this.setVolumeFixed(false);
                        break;
                    }
                    case 1: {
                        Box2D.this.setVolumeFixed(true);
                        break;
                    }
                    default: {
                        throw new RuntimeException("Invalid constantProperty");
                    }
                }
            }
        });
    }

    public double getKineticEnergy() {
        return 0.0;
    }

    public Point2D getCM() {
        return this.center;
    }

    public double getMomentOfInertia() {
        return Double.MAX_VALUE;
    }

    public void setBounds(double d, double d2, double d3, double d4) {
        this.setState(new Point2D.Double(d, d2), new Point2D.Double(d3, d4));
        this.changeListenerProxy.boundsChanged(new ChangeEvent(this));
    }

    public void notifyObservers() {
        if (this.autoNotify) {
            super.notifyObservers();
        }
    }

    private void setState(Point2D point2D, Point2D point2D2) {
        this.setAutoNotify(false);
        this.corner1 = point2D;
        this.corner2 = point2D2;
        this.maxX = Math.max(point2D.getX(), point2D2.getX());
        this.maxY = Math.max(point2D.getY(), point2D2.getY());
        this.minX = Math.max(Math.min(Math.min(point2D.getX(), point2D2.getX()), this.maxX - this.minimumWidth), 40.0);
        this.minY = Math.min(point2D.getY(), point2D2.getY());
        this.center = new Point2D.Double((this.maxX + this.minX) / 2.0, (this.maxY + this.minY) / 2.0);
        this.setPosition(new Point2D.Double(this.minX, this.minY));
        Point2D[] point2DArray = this.getOpening();
        point2DArray[0].setLocation(point2DArray[0].getX(), this.minY);
        point2DArray[1].setLocation(point2DArray[1].getX(), this.minY);
        this.setOpening(point2DArray);
        this.setAutoNotify(true);
        this.notifyObservers();
    }

    private void setAutoNotify(boolean bl) {
        this.autoNotify = bl;
    }

    public void setMinimumWidth(double d) {
        this.minimumWidth = d;
    }

    public double getMinimumWidth() {
        return this.minimumWidth;
    }

    public void setOpening(Point2D[] point2DArray) {
        this.opening[0] = point2DArray[0];
        this.opening[1] = point2DArray[1];
        this.openingLine = new Line2D.Double(point2DArray[0], point2DArray[1]);
        this.notifyObservers();
        this.changeListenerProxy.boundsChanged(new ChangeEvent(this));
    }

    public Point2D[] getOpening() {
        return this.opening;
    }

    public boolean isInOpening(CollidableBody collidableBody) {
        boolean bl = false;
        if (collidableBody instanceof SphericalBody) {
            SphericalBody sphericalBody = (SphericalBody)collidableBody;
            bl = sphericalBody.getPosition().getX() >= this.opening[0].getX() && sphericalBody.getPosition().getX() <= this.opening[1].getX() && sphericalBody.getPosition().getY() - sphericalBody.getRadius() <= this.getMinY();
        }
        return bl;
    }

    public boolean passedThroughOpening(GasMolecule gasMolecule) {
        Point2D point2D = gasMolecule.getPosition();
        Point2D point2D2 = gasMolecule.getPositionPrev();
        return this.openingLine.intersectsLine(point2D.getX(), point2D.getY(), point2D2.getX(), point2D2.getY());
    }

    public void stepInTime(double d) {
        this.leftWallVx = (this.minX - this.oldMinX) / d;
        this.oldMinX = this.minX;
    }

    public Rectangle2D getBoundsInternal() {
        return new Rectangle2D.Double(this.getCorner1X(), this.getCorner1Y(), this.getWidth(), this.getHeight());
    }

    public double getCorner1X() {
        return this.corner1.getX();
    }

    public double getCorner1Y() {
        return this.corner1.getY();
    }

    public double getCorner2X() {
        return this.corner2.getX();
    }

    public double getCorner2Y() {
        return this.corner2.getY();
    }

    public double getMinX() {
        return this.minX;
    }

    public double getMinY() {
        return this.minY;
    }

    public double getMaxX() {
        return this.maxX;
    }

    public double getMaxY() {
        return this.maxY;
    }

    public double getWidth() {
        return Math.abs(this.corner2.getX() - this.corner1.getX());
    }

    public double getHeight() {
        return Math.abs(this.corner2.getY() - this.corner1.getY());
    }

    public double getLeftWallVx() {
        return this.leftWallVx;
    }

    public boolean isVolumeFixed() {
        return this.volumeFixed;
    }

    public void setVolumeFixed(boolean bl) {
        boolean bl2 = false;
        if (this.volumeFixed != bl) {
            bl2 = true;
        }
        this.volumeFixed = bl;
        if (bl2) {
            this.changeListenerProxy.isVolumeFixedChanged(new ChangeEvent(this));
        }
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.changeEventChannel.addListener(changeListener);
    }

    public class ChangeEvent
    extends EventObject {
        public ChangeEvent(Object object) {
            super(object);
        }

        public Box2D getBox2D() {
            return (Box2D)this.getSource();
        }
    }

    public static interface ChangeListener
    extends EventListener {
        public void boundsChanged(ChangeEvent var1);

        public void isVolumeFixedChanged(ChangeEvent var1);
    }

    public static class ChangeListenerAdapter
    implements ChangeListener {
        public void boundsChanged(ChangeEvent changeEvent) {
        }

        public void isVolumeFixedChanged(ChangeEvent changeEvent) {
        }
    }
}

