/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.idealgas.model;

import edu.colorado.phet.common.mechanics.Body;
import edu.colorado.phet.common.phetcommon.model.BaseModel;
import edu.colorado.phet.common.phetcommon.model.ModelElement;
import edu.colorado.phet.common.phetcommon.model.Particle;
import edu.colorado.phet.common.phetcommon.util.EventChannel;
import edu.colorado.phet.common.phetcommon.util.SimpleObservable;
import edu.colorado.phet.common.phetcommon.util.SimpleObserver;
import edu.colorado.phet.idealgas.IdealGasConfig;
import edu.colorado.phet.idealgas.collision.CollidableBody;
import edu.colorado.phet.idealgas.collision.CollisionExpert;
import edu.colorado.phet.idealgas.collision.CollisionGod;
import edu.colorado.phet.idealgas.collision.SphereSphereExpert;
import edu.colorado.phet.idealgas.model.Box2D;
import edu.colorado.phet.idealgas.model.GasMolecule;
import edu.colorado.phet.idealgas.model.Gravity;
import edu.colorado.phet.idealgas.model.HeavySpecies;
import edu.colorado.phet.idealgas.model.LightSpecies;
import edu.colorado.phet.idealgas.model.PressureSensingBox;
import java.awt.Shape;
import java.awt.geom.Area;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EventListener;
import java.util.EventObject;
import java.util.List;

public class IdealGasModel
extends BaseModel
implements Gravity.ChangeListener {
    private Gravity gravity;
    private double heatSource;
    private PressureSensingBox box;
    private int constantProperty = 0;
    private double targetPressure = 0.0;
    private double averageMoleculeEnergy;
    private double deltaKE = 0.0;
    private ArrayList externalForces = new ArrayList();
    private List prepCommands = Collections.synchronizedList(new ArrayList());
    private ArrayList removeList = new ArrayList();
    private ArrayList bodies = new ArrayList();
    private CollisionGod collisionGod;
    private boolean currentlyInStepInTimeMethod;
    private List collisionExperts = new ArrayList();
    private double averageHeavySpeciesSpeed;
    private double averageLightSpeciesSpeed;
    private int heavySpeciesCnt;
    private int lightSpeciesCnt;
    private Shape modelBounds;
    private double targetTemperature;
    private SimpleObservable simpleObservable = new SimpleObservable();
    private boolean isWorkDoneByMovingWall = true;
    private EventChannel changeEventChannel = new EventChannel(ChangeListener.class);
    private ChangeListener changeListenerProxy = (ChangeListener)this.changeEventChannel.getListenerProxy();
    private EventChannel heatSourceChangeChannel = new EventChannel(HeatSourceChangeListener.class);
    private HeatSourceChangeListener heatSourceChangeListenerProxy = (HeatSourceChangeListener)this.heatSourceChangeChannel.getListenerProxy();

    public IdealGasModel(double d) {
        this.collisionGod = new CollisionGod(this, d, new Rectangle2D.Double(0.0, 0.0, 600.0, 600.0), 10, 10);
    }

    public void addCollisionExpert(CollisionExpert collisionExpert) {
        this.collisionExperts.add(collisionExpert);
    }

    public boolean isConstantVolume() {
        return this.constantProperty == 1;
    }

    public boolean isConstantPressure() {
        return this.constantProperty == 2;
    }

    public boolean isConstantTemperature() {
        return this.constantProperty == 3;
    }

    public boolean isConstantNone() {
        return !this.isConstantPressure() && !this.isConstantTemperature() && !this.isConstantVolume();
    }

    public void setConstantProperty(int n) {
        this.constantProperty = n;
        switch (n) {
            case 0: {
                this.setWorkDoneByMovingWall(true);
                break;
            }
            case 1: {
                this.setWorkDoneByMovingWall(true);
                break;
            }
            case 2: {
                this.setWorkDoneByMovingWall(false);
                this.targetPressure = this.box.getPressure();
                break;
            }
            case 3: {
                this.setWorkDoneByMovingWall(true);
                double d = this.getTemperature();
                this.targetTemperature = !Double.isNaN(d) ? d : 15000.0;
                break;
            }
            default: {
                throw new RuntimeException("Invalid constantProperty");
            }
        }
        this.changeListenerProxy.stateChanged(new ChangeEvent(this));
    }

    public int getConstantProperty() {
        return this.constantProperty;
    }

    private void updateFreeParameter() {
        switch (this.constantProperty) {
            case 2: {
                double d = this.box.getPressure();
                double d2 = (d - this.targetPressure) / this.targetPressure;
                if (d > 0.0 && d2 > (double)0.05f) {
                    this.box.setBounds(this.box.getMinX() - 1.0, this.box.getMinY(), this.box.getMaxX(), this.box.getMaxY());
                    break;
                }
                if (!(d > 0.0) || !(d2 < (double)-0.05f)) break;
                this.box.setBounds(this.box.getMinX() + 1.0, this.box.getMinY(), this.box.getMaxX(), this.box.getMaxY());
                break;
            }
            case 3: {
                double d = this.getTemperature();
                double d3 = 0.0;
                if (!Double.isNaN(d)) {
                    d3 = 100.0 * (this.targetTemperature - d) / this.targetTemperature;
                }
                this.setHeatSource(d3);
            }
        }
    }

    public Gravity getGravity() {
        return this.gravity;
    }

    public void setHeatSource(double d) {
        this.heatSource = d;
        this.heatSourceChangeListenerProxy.heatSourceChanged(new HeatSourceChangeEvent(this));
    }

    public double getHeatSource() {
        return this.heatSource;
    }

    public void addBox(PressureSensingBox pressureSensingBox) {
        this.box = pressureSensingBox;
        this.addModelElement(pressureSensingBox);
    }

    public PressureSensingBox getBox() {
        return this.box;
    }

    public void addModelElement(ModelElement modelElement) {
        if (modelElement instanceof Gravity) {
            this.addExternalForce(modelElement);
            this.gravity = (Gravity)modelElement;
            this.adjustEnergyForGravity(this.gravity.getAmt());
            this.gravity.addListener(this);
        } else {
            Body body;
            super.addModelElement(modelElement);
            if (modelElement instanceof Body) {
                body = (Body)modelElement;
                if (this.currentlyInStepInTimeMethod) {
                    this.addKineticEnergyToSystem(body.getKineticEnergy());
                }
                this.bodies.add(body);
            }
            if (modelElement instanceof HeavySpecies) {
                ++this.heavySpeciesCnt;
            }
            if (modelElement instanceof LightSpecies) {
                ++this.lightSpeciesCnt;
            }
            if (modelElement instanceof Box2D) {
                body = (Box2D)modelElement;
                ((Box2D)body).addChangeListener(new Box2D.ChangeListenerAdapter(){

                    public void boundsChanged(Box2D.ChangeEvent changeEvent) {
                        IdealGasModel.this.setModelBounds();
                    }
                });
            }
        }
    }

    public void removeModelElement(ModelElement modelElement) {
        if (modelElement instanceof Body) {
            if (this.currentlyInStepInTimeMethod) {
                this.addKineticEnergyToSystem(-((Body)modelElement).getKineticEnergy());
            }
            this.bodies.remove(modelElement);
        }
        if (modelElement instanceof GasMolecule) {
            ((GasMolecule)modelElement).removeYourselfFromSystem();
        }
        if (modelElement instanceof HeavySpecies) {
            --this.heavySpeciesCnt;
        }
        if (modelElement instanceof LightSpecies) {
            --this.lightSpeciesCnt;
        }
        if (modelElement instanceof Gravity) {
            this.removeExternalForce(modelElement);
            this.gravity = null;
        } else {
            super.removeModelElement(modelElement);
        }
    }

    private void adjustEnergyForGravity(double d) {
        double d2 = 0.0;
    }

    public synchronized void addExternalForce(ModelElement modelElement) {
        this.externalForces.add(modelElement);
    }

    public synchronized void removeExternalForce(ModelElement modelElement) {
        this.externalForces.remove(modelElement);
    }

    public void addKineticEnergyToSystem(double d) {
        this.deltaKE += d;
    }

    public double getTotalGasEnergy() {
        double d = 0.0;
        for (int i = 0; i < this.numModelElements(); ++i) {
            ModelElement modelElement = this.modelElementAt(i);
            if (!(modelElement instanceof GasMolecule)) continue;
            Body body = (Body)modelElement;
            d += this.getBodyEnergy(body);
        }
        return d;
    }

    public double getTotalEnergy() {
        double d = 0.0;
        for (int i = 0; i < this.numModelElements(); ++i) {
            ModelElement modelElement = this.modelElementAt(i);
            if (!(modelElement instanceof Body)) continue;
            Body body = (Body)modelElement;
            d += this.getBodyEnergy(body);
        }
        return d;
    }

    public double getTemperature() {
        double d = 0.0;
        int n = 0;
        for (int i = 0; i < this.numModelElements(); ++i) {
            ModelElement modelElement = this.modelElementAt(i);
            if (!(modelElement instanceof GasMolecule)) continue;
            ++n;
            GasMolecule gasMolecule = (GasMolecule)modelElement;
            double d2 = gasMolecule.getKineticEnergy();
            if (Double.isNaN(d2)) {
                System.out.println("Total kinetic energy in system NaN: " + gasMolecule.getClass());
                continue;
            }
            d += d2;
        }
        return d / (double)n;
    }

    public double getTotalKineticEnergy() {
        double d = 0.0;
        for (int i = 0; i < this.numModelElements(); ++i) {
            ModelElement modelElement = this.modelElementAt(i);
            if (!(modelElement instanceof Body)) continue;
            Body body = (Body)modelElement;
            double d2 = body.getKineticEnergy();
            if (Double.isNaN(d2)) {
                System.out.println("Total kinetic energy in system NaN: " + body.getClass());
                continue;
            }
            d += d2;
        }
        return d;
    }

    public void stepInTime(double d) {
        ModelElement modelElement;
        int n;
        this.currentlyInStepInTimeMethod = true;
        double d2 = this.getTotalEnergy();
        for (n = 0; n < this.bodies.size(); ++n) {
            modelElement = (Body)this.bodies.get(n);
            ((Particle)modelElement).setAccelerationNoUpdate(0.0, 0.0);
        }
        for (n = 0; n < this.externalForces.size(); ++n) {
            modelElement = (ModelElement)this.externalForces.get(n);
            modelElement.stepInTime(d);
        }
        this.addHeatFromStove();
        super.stepInTime(d);
        this.collisionGod.doYourThing(d, this.collisionExperts);
        double d3 = this.getTotalEnergy();
        double d4 = this.getTotalKineticEnergy();
        double d5 = d3 - (d2 + this.deltaKE);
        double d6 = d5 / d4;
        double d7 = Math.sqrt(1.0 - d6);
        this.deltaKE = 0.0;
        if (d2 != 0.0 && d7 != 1.0) {
            for (int i = 0; i < this.numModelElements(); ++i) {
                ModelElement modelElement2 = this.modelElementAt(i);
                if (!(modelElement2 instanceof Body)) continue;
                Body body = (Body)modelElement2;
                double d8 = body.getVelocity().getX();
                double d9 = body.getVelocity().getY();
                d8 *= d7;
                d9 *= d7;
                if (Double.isNaN(d7) || !(body.getKineticEnergy() > 0.0)) continue;
                body.setVelocity(d8, d9);
            }
        }
        this.removeEscapedMolecules();
        this.computeStatistics();
        this.currentlyInStepInTimeMethod = false;
        this.updateFreeParameter();
        this.notifyObservers();
    }

    private void removeEscapedMolecules() {
        ModelElement modelElement;
        int n;
        this.removeList.clear();
        for (n = 0; n < this.numModelElements(); ++n) {
            modelElement = this.modelElementAt(n);
            if (!(modelElement instanceof GasMolecule)) continue;
            GasMolecule gasMolecule = (GasMolecule)modelElement;
            if (this.box.passedThroughOpening(gasMolecule)) {
                if (this.box.containsBody(gasMolecule)) {
                    this.box.removeContainedBody(gasMolecule);
                } else {
                    this.box.addContainedBody(gasMolecule);
                }
            }
            if (this.modelBounds.contains(gasMolecule.getPosition())) continue;
            this.removeList.add(gasMolecule);
        }
        for (n = 0; n < this.removeList.size(); ++n) {
            modelElement = (GasMolecule)this.removeList.get(n);
            this.bodies.remove(modelElement);
            this.removeModelElement(modelElement);
        }
    }

    private void computeStatistics() {
        int n = 0;
        int n2 = 0;
        double d = 0.0;
        double d2 = 0.0;
        for (int i = 0; i < this.numModelElements(); ++i) {
            ModelElement modelElement = this.modelElementAt(i);
            if (!(modelElement instanceof GasMolecule)) continue;
            GasMolecule gasMolecule = (GasMolecule)modelElement;
            n2 = (int)((double)n2 + this.getBodyEnergy(gasMolecule));
            if (modelElement instanceof HeavySpecies) {
                d2 += gasMolecule.getSpeed();
            }
            if (modelElement instanceof LightSpecies) {
                d += gasMolecule.getSpeed();
            }
            ++n;
        }
        this.averageMoleculeEnergy = n != 0 ? (double)(n2 / n) : 0.0;
        this.averageHeavySpeciesSpeed = this.getHeavySpeciesCnt() > 0 ? d2 / (double)this.getHeavySpeciesCnt() : 0.0;
        this.averageLightSpeciesSpeed = this.getLightSpeciesCnt() > 0 ? d / (double)this.getLightSpeciesCnt() : 0.0;
    }

    private void addHeatFromStove() {
        if (this.heatSource != 0.0) {
            for (int i = 0; i < this.numModelElements(); ++i) {
                ModelElement modelElement = this.modelElementAt(i);
                if (!(modelElement instanceof CollidableBody) || IdealGasConfig.HEAT_ONLY_FROM_FLOOR) continue;
                CollidableBody collidableBody = (CollidableBody)modelElement;
                double d = collidableBody.getKineticEnergy();
                collidableBody.setVelocity(collidableBody.getVelocity().scale(1.0 + this.heatSource / 10000.0));
                double d2 = collidableBody.getKineticEnergy() - d;
                if (!this.currentlyInStepInTimeMethod) continue;
                this.addKineticEnergyToSystem(d2);
            }
        }
    }

    public double getBodyEnergy(Body body) {
        double d = body.getKineticEnergy() + this.getPotentialEnergy(body);
        return d;
    }

    public double getPotentialEnergy(Body body) {
        double d;
        double d2 = 0.0;
        if (this.gravity != null && (d = this.getGravity().getAmt()) != 0.0) {
            double d3 = this.getBox().getMaxY();
            if (body.getMass() != Double.POSITIVE_INFINITY) {
                d2 = (d3 - body.getPosition().getY()) * d * body.getMass();
            }
        }
        return d2;
    }

    public List getBodies() {
        return this.bodies;
    }

    public double getAverageGasEnergy() {
        return this.getTotalGasEnergy() / (double)this.getNumMolecules();
    }

    public int getNumMolecules() {
        return this.getHeavySpeciesCnt() + this.getLightSpeciesCnt();
    }

    public int getHeavySpeciesCnt() {
        return this.heavySpeciesCnt;
    }

    public int getLightSpeciesCnt() {
        return this.lightSpeciesCnt;
    }

    public double getHeavySpeciesAveSpeed() {
        return this.averageHeavySpeciesSpeed;
    }

    public double getLightSpeciesAveSpeed() {
        return this.averageLightSpeciesSpeed;
    }

    public void setWorkDoneByMovingWall(boolean bl) {
        this.isWorkDoneByMovingWall = bl;
    }

    public boolean isWorkDoneByMovingWall() {
        return this.isWorkDoneByMovingWall;
    }

    public void removeAllMolecules() {
        ModelElement modelElement;
        int n;
        ArrayList<ModelElement> arrayList = new ArrayList<ModelElement>();
        for (n = 0; n < this.bodies.size(); ++n) {
            modelElement = (ModelElement)this.bodies.get(n);
            if (!(modelElement instanceof GasMolecule)) continue;
            arrayList.add(modelElement);
        }
        for (n = 0; n < arrayList.size(); ++n) {
            modelElement = (GasMolecule)arrayList.get(n);
            this.removeModelElement(modelElement);
        }
    }

    public void setModelBounds() {
        Rectangle2D rectangle2D = this.box.getBoundsInternal();
        int n = 10;
        rectangle2D = new Rectangle2D.Double(0.0, rectangle2D.getBounds().getY() - (double)n, 1000.0, rectangle2D.getBounds().getHeight() + (double)(2 * n));
        Point2D point2D = this.box.getOpening()[0];
        Point2D point2D2 = this.box.getOpening()[1];
        Rectangle2D.Double double_ = new Rectangle2D.Double(point2D.getX(), 40.0, point2D2.getX() - point2D.getX(), point2D.getY());
        Area area = new Area(rectangle2D);
        area.add(new Area(double_));
        this.modelBounds = area;
    }

    public void addObserver(SimpleObserver simpleObserver) {
        this.simpleObservable.addObserver(simpleObserver);
    }

    public void notifyObservers() {
        this.simpleObservable.notifyObservers();
    }

    public void gravityChanged(Gravity.ChangeEvent changeEvent) {
        this.adjustEnergyForGravity(changeEvent.getChange());
    }

    public void enableParticleParticleInteractions(boolean bl) {
        for (int i = 0; i < this.collisionExperts.size(); ++i) {
            CollisionExpert collisionExpert = (CollisionExpert)this.collisionExperts.get(i);
            if (!(collisionExpert instanceof SphereSphereExpert)) continue;
            SphereSphereExpert.setIgnoreGasMoleculeInteractions(!bl);
        }
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.changeEventChannel.addListener(changeListener);
    }

    public void addHeatSourceChangeListener(HeatSourceChangeListener heatSourceChangeListener) {
        this.heatSourceChangeChannel.addListener(heatSourceChangeListener);
    }

    public class ChangeEvent
    extends EventObject {
        public ChangeEvent(Object object) {
            super(object);
        }

        public IdealGasModel getModel() {
            return (IdealGasModel)this.getSource();
        }
    }

    public static interface ChangeListener
    extends EventListener {
        public void stateChanged(ChangeEvent var1);
    }

    public class HeatSourceChangeEvent
    extends EventObject {
        public HeatSourceChangeEvent(Object object) {
            super(object);
        }

        public double getHeatSource() {
            return IdealGasModel.this.heatSource;
        }
    }

    public static interface HeatSourceChangeListener
    extends EventListener {
        public void heatSourceChanged(HeatSourceChangeEvent var1);
    }
}

