/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.idealgas.view;

import edu.colorado.phet.common.phetcommon.util.SimpleObserver;
import edu.colorado.phet.common.phetgraphics.view.phetgraphics.PhetGraphic;
import edu.colorado.phet.common.phetgraphics.view.util.GraphicsUtil;
import edu.colorado.phet.idealgas.IdealGasResources;
import edu.colorado.phet.idealgas.model.HotAirBalloon;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.geom.Arc2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;

public class HotAirBalloonGraphic
extends PhetGraphic
implements SimpleObserver {
    private static float s_strokeWidth = 2.0f;
    private static Stroke s_defaultStroke = new BasicStroke(s_strokeWidth);
    private static Color s_defaultColor = Color.ORANGE;
    private static float s_balloonOpacity = 0.3f;
    private Arc2D.Double balloonShape = new Arc2D.Double(1);
    private Rectangle bounds = new Rectangle();
    private BufferedImage burner;
    private BufferedImage flames;
    private int flameHeight;
    private HotAirBalloon balloon;
    private ImageObserver imgObs;

    public HotAirBalloonGraphic(Component component, HotAirBalloon hotAirBalloon) {
        super(component);
        this.balloon = hotAirBalloon;
        hotAirBalloon.addObserver(this);
        this.burner = IdealGasResources.getImage("stove.png");
        this.flames = IdealGasResources.getImage("hot-air-balloon-flames.gif");
        this.imgObs = new ImageObserver(){

            public boolean imageUpdate(Image image, int n, int n2, int n3, int n4, int n5) {
                return false;
            }
        };
        this.update();
        super.setIgnoreMouse(true);
    }

    protected Rectangle determineBounds() {
        this.bounds.setBounds((int)(this.balloonShape.getMinX() - (double)(s_strokeWidth / 2.0f)), (int)(this.balloonShape.getMinY() - (double)(s_strokeWidth / 2.0f)), (int)(this.balloonShape.getWidth() + (double)(2.0f * s_strokeWidth)), (int)(this.balloonShape.getHeight() + (double)this.burner.getHeight() + (double)(s_strokeWidth / 2.0f)));
        return this.bounds;
    }

    public void update() {
        this.setPosition();
        this.flameHeight = (int)this.balloon.getHeatSource() * 2 / 3;
        this.setBoundsDirty();
        this.repaint();
    }

    protected void setPosition() {
        double d = -(90.0 - this.balloon.getOpeningAngle() / 2.0);
        double d2 = 360.0 - this.balloon.getOpeningAngle();
        this.balloonShape.setArc(this.balloon.getCenter().getX() - this.balloon.getRadius(), this.balloon.getCenter().getY() - this.balloon.getRadius(), this.balloon.getRadius() * 2.0, this.balloon.getRadius() * 2.0, d, d2, 1);
    }

    public void paint(Graphics2D graphics2D) {
        this.saveGraphicsState(graphics2D);
        GraphicsUtil.setAntiAliasingOn(graphics2D);
        graphics2D.setStroke(s_defaultStroke);
        graphics2D.setColor(s_defaultColor);
        graphics2D.draw(this.balloonShape);
        GraphicsUtil.setAlpha(graphics2D, s_balloonOpacity);
        graphics2D.fill(this.balloonShape);
        GraphicsUtil.setAlpha(graphics2D, 1.0);
        Rectangle2D rectangle2D = this.balloon.getOpening();
        int n = (int)(rectangle2D.getMaxX() + rectangle2D.getMinX()) / 2;
        int n2 = (int)(rectangle2D.getMaxX() - rectangle2D.getMinX()) * 2 / 3;
        int n3 = n2 * 2 / 3;
        graphics2D.drawImage(this.flames, n - n3 / 2, (int)rectangle2D.getMinY() - this.flameHeight, n3, this.flameHeight, this.imgObs);
        graphics2D.drawImage(this.burner, n - n2 / 2, (int)rectangle2D.getMinY(), n2, (int)(rectangle2D.getMaxY() - rectangle2D.getMinY()) / 2, this.imgObs);
        this.restoreGraphicsState();
    }
}

