/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.idealgas.view;

import edu.colorado.phet.common.phetcommon.application.PhetApplication;
import edu.colorado.phet.common.phetcommon.model.clock.IClock;
import edu.colorado.phet.common.phetgraphics.view.graphics.mousecontrols.translation.TranslationEvent;
import edu.colorado.phet.common.phetgraphics.view.graphics.mousecontrols.translation.TranslationListener;
import edu.colorado.phet.common.phetgraphics.view.phetgraphics.CompositePhetGraphic;
import edu.colorado.phet.common.phetgraphics.view.phetgraphics.PhetGraphic;
import edu.colorado.phet.common.phetgraphics.view.phetgraphics.PhetImageGraphic;
import edu.colorado.phet.idealgas.model.Pump;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;

public class PumpHandleGraphic
extends CompositePhetGraphic {
    private Pump pump;
    private PhetImageGraphic image;
    private int lastYPumped;
    private int lastYTracked = Integer.MAX_VALUE;
    private Rectangle hitRect = new Rectangle();

    public PumpHandleGraphic(Component component, Pump pump, PhetImageGraphic phetImageGraphic, int n, int n2, int n3, int n4, int n5, int n6) {
        super(component);
        this.pump = pump;
        this.image = phetImageGraphic;
        phetImageGraphic.setLocation(n, n2);
        this.updateHitRect();
        this.setCursor(Cursor.getPredefinedCursor(8));
        this.addTranslationListener(new PumpHandleTranslator(n, n2, n3, n4, n5, n6));
    }

    public void paint(Graphics2D graphics2D) {
        this.image.paint(graphics2D);
    }

    public void fireMouseDragged(MouseEvent mouseEvent) {
        super.fireMouseDragged(mouseEvent);
        int n = mouseEvent.getY();
        if (n > this.lastYTracked) {
            int n2 = (n - this.lastYPumped) / 2;
            this.pump.pump(n2);
            this.lastYPumped = n;
            IClock iClock = PhetApplication.getInstance().getActiveModule().getClock();
            if (iClock.isPaused()) {
                iClock.pause();
            }
        }
        this.lastYTracked = n;
    }

    private void updateHitRect() {
        this.hitRect.setRect(this.image.getLocation().x, this.image.getLocation().y, this.image.getWidth(), 20.0);
    }

    protected Rectangle determineBounds() {
        return this.image.getBounds();
    }

    protected PhetGraphic getHandler(Point point) {
        if (this.getVisibilityFlag() && this.hitRect.contains(point)) {
            return this;
        }
        return null;
    }

    private class PumpHandleTranslator
    implements TranslationListener {
        private int x;
        private int y;
        private int minX;
        private int minY;
        private int maxX;
        private int maxY;

        public PumpHandleTranslator(int n, int n2, int n3, int n4, int n5, int n6) {
            this.x = n;
            this.y = n2;
            this.minX = n3;
            this.minY = n4;
            this.maxX = n5;
            this.maxY = n6;
        }

        public void translationOccurred(TranslationEvent translationEvent) {
            double d = translationEvent.getDx();
            double d2 = translationEvent.getDy();
            this.x = (int)Math.min((double)this.maxX, Math.max((double)this.minX, (double)this.x + d));
            this.y = (int)Math.min((double)this.maxY, Math.max((double)this.minY, (double)this.y + d2));
            PumpHandleGraphic.this.image.setLocation(this.x, this.y);
            PumpHandleGraphic.this.setLocation(PumpHandleGraphic.this.image.getLocation());
            PumpHandleGraphic.this.updateHitRect();
        }
    }
}

