/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.idealgas.view.monitors;

import edu.colorado.phet.common.mechanics.Body;
import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import edu.colorado.phet.common.phetgraphics.view.util.GraphicsState;
import edu.colorado.phet.idealgas.IdealGasResources;
import edu.colorado.phet.idealgas.instrumentation.Histogram;
import edu.colorado.phet.idealgas.model.GasMolecule;
import edu.colorado.phet.idealgas.model.HeavySpecies;
import edu.colorado.phet.idealgas.model.IdealGasModel;
import edu.colorado.phet.idealgas.model.LightSpecies;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.geom.AffineTransform;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class EnergyHistogramDialog
extends JDialog {
    private Histogram energyHistogram;
    private int averagingRatio = 4;
    private int initialEnergyClippingLevel = 50;
    private int initialSpeedClippingLevel = 20;
    private double maxKineticEnergy = 150000.0;
    private double maxSpeed = 200.0;
    private Histogram speedHistogram;
    private Histogram heavySpeedHistogram;
    private Histogram lightSpeedHistogram;
    private boolean showDetails;
    private JButton detailsBtn;
    private JLabel lightSpeedLabel;
    private JLabel heavySpeedLabel;
    private IdealGasModel model;
    private RotatedTextLabel heavySpeedYLabel;
    private RotatedTextLabel lightSpeedYLabel;
    private Updater updater;
    private String inRangeIndicator = "  ";
    private String outOfRangeIndicator = ">>";
    private JLabel energyOutOfRangeIndicator = new JLabel(this.outOfRangeIndicator);
    private JLabel speedOutOfRangeIndicator = new JLabel(this.outOfRangeIndicator);
    private JLabel heavySpeciesSpeedOutOfRangeIndicator = new JLabel(this.outOfRangeIndicator);
    private JLabel lightSpeciesSpeedOutOfRangeIndicator = new JLabel(this.outOfRangeIndicator);
    private JLabel outOfRangeIndicatorLegend1 = new JLabel(this.outOfRangeIndicator);
    private JLabel outOfRangeIndicatorLegend2 = new JLabel(new String(" - ").concat(IdealGasResources.getString("EnergyHistorgramDialog.OutOfRangeIndicatorLegend")));
    private Font outOfRangeIndicatorFont;
    private String[] speedDetailsLegends = new String[]{IdealGasResources.getString("EnergyHistorgramDialog.Heavy_Speed_label"), IdealGasResources.getString("EnergyHistorgramDialog.Light_Speed_label")};

    public EnergyHistogramDialog(Frame frame, IdealGasModel idealGasModel) {
        super(frame);
        this.model = idealGasModel;
        this.setTitle(IdealGasResources.getString("EnergyHistorgramDialog.Title"));
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                EnergyHistogramDialog.this.updater.setRunning(false);
            }
        });
        this.energyHistogram = new Histogram(200, 150, 0.0, this.maxKineticEnergy * 1.01, 20, this.initialEnergyClippingLevel * this.averagingRatio, new Color(0, 0, 0));
        this.speedHistogram = new Histogram(200, 150, 0.0, this.maxSpeed * 1.01, 20, this.initialSpeedClippingLevel * this.averagingRatio, new Color(0, 0, 0));
        this.heavySpeedHistogram = new Histogram(200, 150, 0.0, this.maxSpeed * 1.01, 20, this.initialSpeedClippingLevel * this.averagingRatio, new Color(20, 0, 200));
        this.lightSpeedHistogram = new Histogram(200, 150, 0.0, this.maxSpeed * 1.01, 20, this.initialSpeedClippingLevel * this.averagingRatio, new Color(200, 0, 20));
        this.detailsBtn = new JButton();
        this.detailsBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                EnergyHistogramDialog.this.showDetails = !EnergyHistogramDialog.this.showDetails;
                EnergyHistogramDialog.this.hideShowDetails();
            }
        });
        this.layoutComponents();
        this.setDefaultCloseOperation(2);
        this.hideShowDetails();
        this.pack();
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                JDialog jDialog = (JDialog)windowEvent.getSource();
                jDialog.setVisible(false);
                jDialog.dispose();
            }
        });
        this.updater = new Updater(idealGasModel);
        this.updater.addClient(new EnergyUpdaterClient(idealGasModel, this.energyHistogram));
        this.updater.addClient(new SpeedUpdaterClient(this.speedHistogram));
        this.updater.addClient(new SpeciesSpeedUpdaterClient(HeavySpecies.class, this.heavySpeedHistogram));
        this.updater.addClient(new SpeciesSpeedUpdaterClient(LightSpecies.class, this.lightSpeedHistogram));
        this.updater.start();
    }

    public void setSpeedDetailsLegends(String[] stringArray, Color[] colorArray) {
        this.speedDetailsLegends = stringArray;
        this.heavySpeedLabel.setText(stringArray[0]);
        this.lightSpeedLabel.setText(stringArray[1]);
        this.heavySpeedHistogram.setColor(colorArray[0]);
        this.lightSpeedHistogram.setColor(colorArray[1]);
    }

    private void hideShowDetails() {
        this.heavySpeedHistogram.setVisible(this.showDetails);
        this.heavySpeedLabel.setVisible(this.showDetails);
        this.lightSpeedHistogram.setVisible(this.showDetails);
        this.lightSpeedLabel.setVisible(this.showDetails);
        this.heavySpeedYLabel.setVisible(this.showDetails);
        this.lightSpeedYLabel.setVisible(this.showDetails);
        if (this.showDetails) {
            this.detailsBtn.setText(IdealGasResources.getString("EnergyHistorgramDialog.Fewer_Details"));
        } else {
            this.detailsBtn.setText(IdealGasResources.getString("EnergyHistorgramDialog.More_Details"));
        }
        this.pack();
        if (this.getHeight() > Toolkit.getDefaultToolkit().getScreenSize().height) {
            this.setSize(this.getWidth(), Toolkit.getDefaultToolkit().getScreenSize().height);
            this.validate();
        }
        this.repaint();
    }

    public void paint(Graphics graphics) {
        this.energyOutOfRangeIndicator.setText(this.energyHistogram.hasDataOutOfRange() ? this.outOfRangeIndicator : this.inRangeIndicator);
        this.speedOutOfRangeIndicator.setText(this.speedHistogram.hasDataOutOfRange() ? this.outOfRangeIndicator : this.inRangeIndicator);
        this.lightSpeciesSpeedOutOfRangeIndicator.setText(this.lightSpeedHistogram.hasDataOutOfRange() ? this.outOfRangeIndicator : this.inRangeIndicator);
        this.heavySpeciesSpeedOutOfRangeIndicator.setText(this.heavySpeedHistogram.hasDataOutOfRange() ? this.outOfRangeIndicator : this.inRangeIndicator);
        super.paint(graphics);
    }

    private void layoutComponents() {
        Insets insets = new Insets(0, 0, 0, 0);
        Insets insets2 = new Insets(0, 0, 12, 0);
        Insets insets3 = new Insets(0, 0, 12, 20);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 0, insets, 0, 0);
        this.heavySpeedLabel = new JLabel(this.speedDetailsLegends[0]);
        this.lightSpeedLabel = new JLabel(this.speedDetailsLegends[1]);
        this.outOfRangeIndicatorFont = new PhetFont(1, 30);
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = insets;
        gridBagConstraints.gridx = 0;
        jPanel.add((Component)new RotatedTextLabel(), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridwidth = 1;
        jPanel.add((Component)this.energyHistogram, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.insets = insets2;
        jPanel.add((Component)new JLabel(IdealGasResources.getString("EnergyHistorgramDialog.Energy_Distribution")), gridBagConstraints);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridx = 2;
        gridBagConstraints.insets = insets3;
        this.energyOutOfRangeIndicator.setForeground(Color.red);
        jPanel.add((Component)this.energyOutOfRangeIndicator, gridBagConstraints);
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = insets;
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        jPanel.add((Component)new RotatedTextLabel(), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        jPanel.add((Component)this.speedHistogram, gridBagConstraints);
        jPanel.add((Component)new RotatedTextLabel(), gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.insets = insets2;
        jPanel.add((Component)new JLabel(IdealGasResources.getString("EnergyHistorgramDialog.Speed_Distribution")), gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.insets = insets3;
        this.speedOutOfRangeIndicator.setForeground(Color.red);
        jPanel.add((Component)this.speedOutOfRangeIndicator, gridBagConstraints);
        gridBagConstraints.insets = insets;
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridx = 0;
        this.heavySpeedYLabel = new RotatedTextLabel();
        jPanel.add((Component)this.heavySpeedYLabel, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        jPanel.add((Component)this.heavySpeedHistogram, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.insets = insets2;
        jPanel.add((Component)this.heavySpeedLabel, gridBagConstraints);
        ++gridBagConstraints.gridx;
        gridBagConstraints.insets = insets3;
        this.heavySpeciesSpeedOutOfRangeIndicator.setForeground(Color.red);
        jPanel.add((Component)this.heavySpeciesSpeedOutOfRangeIndicator, gridBagConstraints);
        gridBagConstraints.insets = insets;
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridx = 0;
        this.lightSpeedYLabel = new RotatedTextLabel();
        jPanel.add((Component)this.lightSpeedYLabel, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        jPanel.add((Component)this.lightSpeedHistogram, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.insets = insets2;
        jPanel.add((Component)this.lightSpeedLabel, gridBagConstraints);
        ++gridBagConstraints.gridx;
        gridBagConstraints.insets = insets3;
        this.lightSpeciesSpeedOutOfRangeIndicator.setForeground(Color.red);
        jPanel.add((Component)this.lightSpeciesSpeedOutOfRangeIndicator, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 25, 0, 0);
        this.outOfRangeIndicatorLegend1.setForeground(Color.red);
        jPanel.add((Component)this.outOfRangeIndicatorLegend1, gridBagConstraints);
        ++gridBagConstraints.gridx;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = insets;
        this.outOfRangeIndicatorLegend2.setForeground(Color.black);
        jPanel.add((Component)this.outOfRangeIndicatorLegend2, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = new Insets(10, 10, 10, 10);
        jPanel.add((Component)this.detailsBtn, gridBagConstraints);
        this.setContentPane(new JScrollPane(jPanel));
    }

    private class EnergyUpdaterClient
    extends UpdaterClient {
        private IdealGasModel model;

        EnergyUpdaterClient(IdealGasModel idealGasModel, Histogram histogram) {
            super(histogram);
            this.model = idealGasModel;
        }

        protected double getBodyAttribute(Body body) {
            return body.getKineticEnergy();
        }

        protected int getClippingLevel() {
            int n = EnergyHistogramDialog.this.averagingRatio * Math.max(this.model.getBodies().size() / 3, EnergyHistogramDialog.this.initialEnergyClippingLevel);
            return n;
        }
    }

    private static class RotatedTextLabel
    extends JPanel {
        public RotatedTextLabel() {
            super(null);
            this.setPreferredSize(new Dimension(20, 150));
        }

        public void paint(Graphics graphics) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            GraphicsState graphicsState = new GraphicsState(graphics2D);
            JLabel jLabel = new JLabel();
            Font font = jLabel.getFont();
            int n = 20;
            int n2 = 150;
            AffineTransform affineTransform = new AffineTransform();
            affineTransform.setToRotation(-1.5707963267948966, n, n2);
            graphics2D.transform(affineTransform);
            graphics2D.setFont(font);
            graphics2D.drawString(IdealGasResources.getLocalizedString("chart.label.number.of.particles"), n, n2);
            graphicsState.restoreGraphics();
        }
    }

    private class SpeciesSpeedUpdaterClient
    extends SpeedUpdaterClient {
        private Class species;

        SpeciesSpeedUpdaterClient(Class clazz, Histogram histogram) {
            super(histogram);
            this.species = clazz;
        }

        protected double getBodyAttribute(Body body) {
            if (this.species.isInstance(body)) {
                return super.getBodyAttribute(body);
            }
            return -1.0;
        }
    }

    private class SpeedUpdaterClient
    extends UpdaterClient {
        SpeedUpdaterClient(Histogram histogram) {
            super(histogram);
        }

        protected double getBodyAttribute(Body body) {
            return body.getSpeed();
        }

        protected int getClippingLevel() {
            int n = EnergyHistogramDialog.this.averagingRatio * Math.max(EnergyHistogramDialog.this.model.getBodies().size() / 5, EnergyHistogramDialog.this.initialSpeedClippingLevel);
            return n;
        }
    }

    private class Updater
    extends Thread {
        private IdealGasModel model;
        private ArrayList clients = new ArrayList();
        private boolean isRunning = false;

        Updater(IdealGasModel idealGasModel) {
            this.model = idealGasModel;
        }

        void addClient(UpdaterClient updaterClient) {
            this.clients.add(updaterClient);
        }

        public synchronized boolean isRunning() {
            return this.isRunning;
        }

        public synchronized void setRunning(boolean bl) {
            this.isRunning = bl;
        }

        public void run() {
            int n = 0;
            this.isRunning = true;
            while (this.isRunning()) {
                try {
                    Thread.sleep(200L);
                    if (!EnergyHistogramDialog.this.isVisible()) continue;
                    if (n % EnergyHistogramDialog.this.averagingRatio == 1) {
                        for (int i = 0; i < this.clients.size(); ++i) {
                            UpdaterClient updaterClient = (UpdaterClient)this.clients.get(i);
                            updaterClient.clear();
                        }
                    }
                    List list = this.model.getBodies();
                    for (int i = 0; i < list.size(); ++i) {
                        Body body = (Body)list.get(i);
                        if (!(body instanceof GasMolecule)) continue;
                        for (int j = 0; j < this.clients.size(); ++j) {
                            UpdaterClient updaterClient = (UpdaterClient)this.clients.get(j);
                            updaterClient.recordBody(body);
                        }
                    }
                    if (n++ % EnergyHistogramDialog.this.averagingRatio != 0) continue;
                    EnergyHistogramDialog.this.repaint();
                }
                catch (InterruptedException interruptedException) {
                    interruptedException.printStackTrace();
                }
            }
        }
    }

    private abstract class UpdaterClient {
        Histogram histogram;

        UpdaterClient(Histogram histogram) {
            this.histogram = histogram;
        }

        void clear() {
            this.histogram.clear();
            this.histogram.setClippingLevel(this.getClippingLevel());
        }

        void recordBody(Body body) {
            this.histogram.add(this.getBodyAttribute(body));
        }

        abstract int getClippingLevel();

        abstract double getBodyAttribute(Body var1);
    }
}

