/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.idealgas.view.monitors;

import edu.colorado.phet.common.phetcommon.util.SimpleObserver;
import edu.colorado.phet.idealgas.IdealGasResources;
import edu.colorado.phet.idealgas.model.GasMolecule;
import edu.colorado.phet.idealgas.model.HeavySpecies;
import edu.colorado.phet.idealgas.model.IdealGasModel;
import edu.colorado.phet.idealgas.model.LightSpecies;
import edu.colorado.phet.idealgas.view.monitors.PhetMonitorPanel;
import java.text.NumberFormat;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;

public class GasSpeciesMonitorPanel
extends PhetMonitorPanel
implements SimpleObserver {
    private double s_screenToModelFactor = 1.45565749235474;
    private double s_aveSpeedReadoutFactor = 10.0 * this.s_screenToModelFactor;
    private int sampleCnt;
    private double runningAveSpeed;
    private Class speciesClass;
    private JTextField numParticlesTF;
    private NumberFormat aveSpeedFormat = NumberFormat.getInstance();
    private JTextField aveSpeedTF;
    private IdealGasModel model;

    public GasSpeciesMonitorPanel(Class clazz, String string, IdealGasModel idealGasModel) {
        this.model = idealGasModel;
        this.speciesClass = clazz;
        this.setUpdateInterval(500L);
        if (!GasMolecule.class.isAssignableFrom(clazz)) {
            throw new RuntimeException("Class other than a gas species class sent to constructor for GasSpeciesMonitorPanel");
        }
        this.setTitle(string);
        this.add(new JLabel(IdealGasResources.getString("GasSpeciesMonitorPanel.Number_of_Gas_Molecules") + ": "));
        this.numParticlesTF = new JTextField(4);
        this.numParticlesTF.setEditable(false);
        this.add(this.numParticlesTF);
        this.aveSpeedFormat.setMaximumFractionDigits(2);
        this.add(new JLabel(IdealGasResources.getString("GasSpeciesMonitorPanel.Average_speed") + ": "));
        this.aveSpeedTF = new JTextField(6);
        this.aveSpeedTF.setEditable(false);
        this.add(this.aveSpeedTF);
        this.add(new JLabel(IdealGasResources.getString("chart.label.msec")));
        idealGasModel.addObserver(this);
    }

    public void setTitle(String string) {
        TitledBorder titledBorder = new TitledBorder(string);
        this.setBorder(titledBorder);
    }

    public void update() {
        long l;
        double d = 0.0;
        int n = 0;
        if (HeavySpecies.class.isAssignableFrom(this.speciesClass)) {
            n = this.model.getHeavySpeciesCnt();
            d = this.model.getHeavySpeciesAveSpeed();
        }
        if (LightSpecies.class.isAssignableFrom(this.speciesClass)) {
            n = this.model.getLightSpeciesCnt();
            d = this.model.getLightSpeciesAveSpeed();
        }
        if ((l = System.currentTimeMillis()) - this.getLastUpdateTime() >= this.getUpdateInterval()) {
            this.setLastUpdateTime(l);
            this.numParticlesTF.setText(Integer.toString(n));
            if (Double.isNaN(this.runningAveSpeed)) {
                // empty if block
            }
            this.aveSpeedTF.setText(this.aveSpeedFormat.format(this.runningAveSpeed / (double)this.sampleCnt * this.s_aveSpeedReadoutFactor));
            this.sampleCnt = 0;
            this.runningAveSpeed = 0.0;
        } else {
            ++this.sampleCnt;
            this.runningAveSpeed += d;
        }
    }
}

