/*
 * Decompiled with CFR 0.152.
 */
package org.bson.io;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;

public abstract class OutputBuffer {
    public abstract void write(byte[] var1);

    public abstract void write(int var1);

    public abstract int getPosition();

    public abstract void setPosition(int var1);

    public abstract int size();

    public abstract int pipe(OutputStream var1) throws IOException;

    public byte[] toByteArray() {
        try {
            ByteArrayOutputStream bout = new ByteArrayOutputStream(this.size());
            this.pipe(bout);
            return bout.toByteArray();
        }
        catch (IOException ioe) {
            throw new RuntimeException("should be impossible", ioe);
        }
    }

    public String asString() {
        return new String(this.toByteArray());
    }

    public String asString(String encoding) throws UnsupportedEncodingException {
        return new String(this.toByteArray(), encoding);
    }

    public void writeInt(int x) {
        this.write(x >> 0);
        this.write(x >> 8);
        this.write(x >> 16);
        this.write(x >> 24);
    }

    public void writeIntBE(int x) {
        this.write(x >> 24);
        this.write(x >> 16);
        this.write(x >> 8);
        this.write(x);
    }

    public void writeInt(int pos, int x) {
        int save = this.getPosition();
        this.setPosition(pos);
        this.writeInt(x);
        this.setPosition(save);
    }

    public void writeLong(long x) {
        this.write((byte)(0xFFL & x >> 0));
        this.write((byte)(0xFFL & x >> 8));
        this.write((byte)(0xFFL & x >> 16));
        this.write((byte)(0xFFL & x >> 24));
        this.write((byte)(0xFFL & x >> 32));
        this.write((byte)(0xFFL & x >> 40));
        this.write((byte)(0xFFL & x >> 48));
        this.write((byte)(0xFFL & x >> 56));
    }

    public void writeDouble(double x) {
        this.writeLong(Double.doubleToRawLongBits(x));
    }

    public String toString() {
        return this.getClass().getName() + " size: " + this.size() + " pos: " + this.getPosition();
    }
}

