/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.microwaves;

import edu.colorado.phet.microwaves.MicrowaveModule;
import edu.colorado.phet.microwaves.MicrowavesResources;
import edu.colorado.phet.microwaves.coreadditions.MessageFormatter;
import edu.colorado.phet.microwaves.coreadditions.collision.Box2D;
import edu.colorado.phet.microwaves.model.WaterMolecule;
import edu.colorado.phet.microwaves.view.WaterMoleculeGraphic;

public class SingleLineOfMoleculesModule2
extends MicrowaveModule {
    public SingleLineOfMoleculesModule2() {
        super(MessageFormatter.format(MicrowavesResources.getString("ModuleTitle.SingleLineOfMoleculesModule2")));
    }

    protected void init() {
        super.init();
        Box2D box2D = this.getMicrowaveModel().getOven();
        int n = (int)(box2D.getMinX() + 20.0 + 20.0);
        while (n < (int)(box2D.getMaxX() - 20.0 - 20.0)) {
            WaterMolecule waterMolecule = new WaterMolecule();
            waterMolecule.setLocation(n, 200.0);
            waterMolecule.setDipoleOrientation(Math.random() * Math.PI * 2.0);
            this.getMicrowaveModel().addPolarBody(waterMolecule);
            WaterMoleculeGraphic waterMoleculeGraphic = new WaterMoleculeGraphic(waterMolecule, this.getModelViewTransform());
            this.getApparatusPanel().addGraphic(waterMoleculeGraphic, 5.0);
            waterMolecule.setVisible(true);
            n = (int)((double)n + 50.0);
        }
    }
}

