/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.microwaves.common.graphics;

import edu.colorado.phet.microwaves.common.graphics.AffineTransformFactory;
import edu.colorado.phet.microwaves.common.graphics.CompositeGraphic;
import edu.colorado.phet.microwaves.common.graphics.Graphic;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.util.Observable;
import java.util.Observer;
import javax.swing.JPanel;
import javax.swing.event.MouseInputAdapter;

public class ApparatusPanel
extends JPanel
implements Observer {
    private MouseHandler mh;
    private CompositeGraphic compositeGraphic = new CompositeGraphic();
    private AffineTransformFactory mvTx;
    private AffineTransform affineTx;
    private AffineTransform inverseAffineTx;
    private BasicStroke borderStroke = new BasicStroke(1.0f);

    public ApparatusPanel(AffineTransformFactory affineTransformFactory) {
        super(null);
        this.mvTx = affineTransformFactory;
        this.mh = new MouseHandler();
        this.addMouseListener(this.mh);
        this.addMouseMotionListener(this.mh);
        this.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent componentEvent) {
                ApparatusPanel.this.updateTransform();
            }
        });
    }

    public void removeAllGraphics() {
        this.compositeGraphic.removeAllGraphics();
    }

    protected void paintComponent(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        super.paintComponent(graphics2D);
        AffineTransform affineTransform = graphics2D.getTransform();
        if (this.affineTx == null) {
            this.updateTransform();
        }
        graphics2D.setTransform(this.affineTx);
        this.compositeGraphic.paint(graphics2D);
        graphics2D.setTransform(affineTransform);
        Rectangle rectangle = this.getBounds();
        graphics.setColor(Color.black);
        graphics2D.setStroke(this.borderStroke);
        graphics2D.drawRect(0, 0, (int)rectangle.getWidth() - 2, (int)rectangle.getHeight() - 2);
    }

    public void addGraphic(Graphic graphic, double d) {
        this.compositeGraphic.addGraphic(graphic, d);
    }

    public void update(Observable observable, Object object) {
        this.repaint();
    }

    public void updateTransform() {
        Rectangle rectangle = this.getBounds();
        this.affineTx = this.mvTx.getTx(rectangle);
        try {
            this.inverseAffineTx = this.affineTx.createInverse();
        }
        catch (NoninvertibleTransformException noninvertibleTransformException) {
            // empty catch block
        }
    }

    private class MouseHandler
    extends MouseInputAdapter {
        private MouseHandler() {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            ApparatusPanel.this.compositeGraphic.mousePressed(mouseEvent, this.getModelLoc(mouseEvent.getPoint()));
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            ApparatusPanel.this.compositeGraphic.mouseReleased(mouseEvent, this.getModelLoc(mouseEvent.getPoint()));
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            ApparatusPanel.this.compositeGraphic.mouseDragged(mouseEvent, this.getModelLoc(mouseEvent.getPoint()));
        }

        public void mouseMoved(MouseEvent mouseEvent) {
            ApparatusPanel.this.compositeGraphic.mouseMoved(mouseEvent, this.getModelLoc(mouseEvent.getPoint()));
        }

        private Point2D.Double getModelLoc(Point point) {
            Point2D.Double double_ = new Point2D.Double();
            ApparatusPanel.this.inverseAffineTx.transform(point, double_);
            return double_;
        }
    }
}

