/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.microwaves.coreadditions;

import edu.colorado.phet.microwaves.common.graphics.ApparatusPanel;
import edu.colorado.phet.microwaves.common.graphics.ModelViewTransform2D;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import javax.swing.JDialog;
import javax.swing.JTextField;
import javax.swing.event.MouseInputAdapter;

public class MeasuringTape
extends MouseInputAdapter {
    Point2D.Double startPoint;
    Point2D.Double endPoint;
    private ApparatusPanel panel;
    private JDialog dialog;
    private JTextField xTF;
    private JTextField yTF;
    private JTextField rTF;
    private JTextField thetaTF;
    private ModelViewTransform2D tx;

    public void mousePressed(MouseEvent mouseEvent) {
        this.startPoint = this.tx.viewToModel((int)mouseEvent.getPoint().getX(), (int)mouseEvent.getPoint().getY());
        this.endPoint = this.tx.viewToModel((int)mouseEvent.getPoint().getX(), (int)mouseEvent.getPoint().getY());
        this.dialog.setLocation((int)(this.panel.getLocationOnScreen().getX() + mouseEvent.getPoint().getX()), (int)(this.panel.getLocationOnScreen().getY() + mouseEvent.getPoint().getY() + 10.0));
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        super.mouseReleased(mouseEvent);
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        super.mouseMoved(mouseEvent);
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        this.endPoint = this.tx.viewToModel((int)mouseEvent.getPoint().getX(), (int)mouseEvent.getPoint().getY());
        double d = this.endPoint.getX() - this.startPoint.getX();
        double d2 = this.endPoint.getY() - this.startPoint.getY();
        double d3 = Math.sqrt(d * d + d2 * d2);
        double d4 = Math.toDegrees(Math.atan2(d2, d));
        this.xTF.setText("x: " + Double.toString((int)d));
        this.yTF.setText("y: " + Double.toString((int)d2));
        this.rTF.setText("r: " + Double.toString((int)d3));
        this.thetaTF.setText("theta: " + Double.toString((int)d4));
    }
}

