/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.microwaves.coreadditions;

public class PhysicalVector {
    private float[] scalars;

    protected PhysicalVector(int n) {
        this.scalars = new float[n];
    }

    protected float getScalarAt(int n) {
        return this.scalars[n];
    }

    protected void setScalarAt(int n, float f) {
        this.scalars[n] = f;
    }

    public boolean equals(Object object) {
        boolean bl = true;
        if (this.getClass() != object.getClass()) {
            bl = false;
        } else {
            PhysicalVector physicalVector = (PhysicalVector)object;
            for (int i = 0; bl && i < this.scalars.length; ++i) {
                if (this.scalars[i] == physicalVector.scalars[i]) continue;
                bl = false;
            }
        }
        return bl;
    }

    public float getMagnitudeSq() {
        float f = 0.0f;
        for (int i = 0; i < this.scalars.length; ++i) {
            f += this.scalars[i] * this.scalars[i];
        }
        return f;
    }

    public float getMagnitude() {
        return (float)Math.sqrt(this.getMagnitudeSq());
    }

    public float getLength() {
        return this.getMagnitude();
    }

    protected PhysicalVector add(PhysicalVector physicalVector, PhysicalVector physicalVector2) {
        for (int i = 0; i < this.scalars.length; ++i) {
            physicalVector2.scalars[i] = this.scalars[i] + physicalVector.scalars[i];
        }
        return physicalVector2;
    }

    protected PhysicalVector generalNormalize() {
        float f = this.getLength();
        return this.multiply(1.0f / f, this);
    }

    protected PhysicalVector multiply(float f, PhysicalVector physicalVector) {
        for (int i = 0; i < this.scalars.length; ++i) {
            physicalVector.scalars[i] = this.scalars[i] * f;
        }
        return physicalVector;
    }

    public float dot(PhysicalVector physicalVector) {
        float f = 0.0f;
        for (int i = 0; i < this.scalars.length; ++i) {
            f += this.scalars[i] * physicalVector.scalars[i];
        }
        return f;
    }

    protected PhysicalVector subtract(PhysicalVector physicalVector, PhysicalVector physicalVector2) {
        for (int i = 0; i < this.scalars.length; ++i) {
            physicalVector2.scalars[i] = this.scalars[i] - physicalVector.scalars[i];
        }
        return physicalVector2;
    }
}

