/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.microwaves.view;

import edu.colorado.phet.microwaves.common.graphics.ModelViewTransform2D;
import edu.colorado.phet.microwaves.coreadditions.TxObservingGraphic;
import edu.colorado.phet.microwaves.coreadditions.collision.Box2D;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.geom.RoundRectangle2D;
import java.util.Observable;

public class OvenGraphic
extends TxObservingGraphic {
    private Box2D box;
    private Stroke stroke = new BasicStroke(3.0f);
    private RoundRectangle2D.Double innerBox = new RoundRectangle2D.Double();
    private RoundRectangle2D.Double outerBox = new RoundRectangle2D.Double();

    public OvenGraphic(Box2D box2D, ModelViewTransform2D modelViewTransform2D) {
        super(modelViewTransform2D);
        this.box = box2D;
        this.update(null, null);
    }

    public void paint(Graphics2D graphics2D) {
        graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        graphics2D.setColor(new Color(200, 200, 200));
        graphics2D.fill(this.outerBox);
        graphics2D.setColor(Color.BLACK);
        graphics2D.draw(this.outerBox);
        graphics2D.setColor(Color.BLACK);
        graphics2D.setStroke(this.stroke);
        graphics2D.draw(this.innerBox);
        graphics2D.setColor(new Color(100, 100, 100));
        graphics2D.fill(this.innerBox);
    }

    public void update(Observable observable, Object object) {
        int n = (int)Math.max(this.box.getMinX(), this.box.getMaxX());
        int n2 = (int)Math.min(this.box.getMinX(), this.box.getMaxX());
        int n3 = (int)Math.min(this.box.getMinY(), this.box.getMaxY());
        int n4 = (int)Math.max(this.box.getMinY(), this.box.getMaxY());
        this.innerBox.setRoundRect(n2, n3, Math.abs(n - n2), n4 - n3, 10.0, 10.0);
        this.outerBox.setRoundRect(n2 - 10, n3 - 8, n - n2 + 20, Math.abs(n4 - n3) + 16, 10.0, 10.0);
    }
}

