/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.microwaves.view;

import edu.colorado.phet.microwaves.common.graphics.ModelViewTransform2D;
import edu.colorado.phet.microwaves.coreadditions.TxObservingGraphic;
import edu.colorado.phet.microwaves.model.WaterMolecule;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.geom.Ellipse2D;
import java.awt.image.ImageObserver;
import java.util.Observable;

public class WaterMoleculeGraphic
extends TxObservingGraphic
implements ImageObserver {
    private WaterMolecule molecule;
    private Point oxygenCenter = new Point();
    private Point hydrogenCenter1 = new Point();
    private Point hydrogenCenter2 = new Point();
    private Ellipse2D atomGraphic = new Ellipse2D.Double();
    private Stroke moleculeStroke = new BasicStroke(1.0f);

    public WaterMoleculeGraphic(WaterMolecule waterMolecule, ModelViewTransform2D modelViewTransform2D) {
        super(modelViewTransform2D);
        this.molecule = waterMolecule;
        waterMolecule.addObserver(this);
        this.update(waterMolecule, null);
    }

    public void paint(Graphics2D graphics2D) {
        if (this.hydrogenCenter1 != null) {
            this.drawAtom(graphics2D, this.hydrogenCenter1.x, this.hydrogenCenter1.y, 10.0, Color.red);
            this.drawAtom(graphics2D, this.hydrogenCenter2.x, this.hydrogenCenter2.y, 10.0, Color.red);
            this.drawAtom(graphics2D, this.oxygenCenter.x, this.oxygenCenter.y, 20.0, Color.blue);
        }
    }

    private void drawAtom(Graphics2D graphics2D, double d, double d2, double d3, Color color) {
        RenderingHints renderingHints = graphics2D.getRenderingHints();
        this.atomGraphic.setFrameFromCenter(d, d2, d + d3, d2 + d3);
        graphics2D.setColor(color);
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.fill(this.atomGraphic);
        graphics2D.setStroke(this.moleculeStroke);
        graphics2D.setColor(Color.BLACK);
        graphics2D.draw(this.atomGraphic);
        graphics2D.setRenderingHints(renderingHints);
    }

    public void update(Observable observable, Object object) {
        if (observable instanceof WaterMolecule) {
            this.oxygenCenter.setLocation(this.molecule.getLobes()[0].getCenter());
            this.hydrogenCenter1.setLocation(this.molecule.getLobes()[1].getCenter());
            this.hydrogenCenter2.setLocation(this.molecule.getLobes()[2].getCenter());
        }
    }

    public boolean imageUpdate(Image image, int n, int n2, int n3, int n4, int n5) {
        return false;
    }
}

