/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.phetcommon.math;

import edu.colorado.phet.common.phetcommon.math.Matrix4F;
import edu.colorado.phet.common.phetcommon.math.vector.Vector3F;
import edu.colorado.phet.common.phetcommon.util.FunctionalUtils;
import java.util.Arrays;

public class Matrix3F {
    public final float v00;
    public final float v01;
    public final float v02;
    public final float v10;
    public final float v11;
    public final float v12;
    public final float v20;
    public final float v21;
    public final float v22;
    public final MatrixType type;
    public static final Matrix3F IDENTITY = Matrix3F.rowMajor(1.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 1.0f, MatrixType.IDENTITY);

    public static Matrix3F rowMajor(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9) {
        return Matrix3F.rowMajor(f, f2, f3, f4, f5, f6, f7, f8, f9, MatrixType.OTHER);
    }

    public static Matrix3F rowMajor(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, MatrixType matrixType) {
        return new Matrix3F(f, f2, f3, f4, f5, f6, f7, f8, f9, matrixType);
    }

    public static Matrix3F columnMajor(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9) {
        return Matrix3F.columnMajor(f, f2, f3, f4, f5, f6, f7, f8, f9, MatrixType.OTHER);
    }

    public static Matrix3F columnMajor(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, MatrixType matrixType) {
        return new Matrix3F(f, f4, f7, f2, f5, f8, f3, f6, f9, matrixType);
    }

    public static Matrix3F rotateAToB(Vector3F vector3F, Vector3F vector3F2) {
        float f;
        Vector3F vector3F3 = vector3F;
        Vector3F vector3F4 = vector3F2;
        float f2 = 1.0E-4f;
        Vector3F vector3F5 = vector3F3.cross(vector3F4);
        float f3 = vector3F3.dot(vector3F4);
        float f4 = f = f3 < 0.0f ? -f3 : f3;
        if (f > 1.0f - f2) {
            Vector3F vector3F6 = new Vector3F((double)vector3F3.x > 0.0 ? vector3F3.x : -vector3F3.x, (double)vector3F3.y > 0.0 ? vector3F3.y : -vector3F3.y, (double)vector3F3.z > 0.0 ? vector3F3.z : -vector3F3.z);
            vector3F6 = vector3F6.x < vector3F6.y ? (vector3F6.x < vector3F6.z ? Vector3F.X_UNIT : Vector3F.Z_UNIT) : (vector3F6.y < vector3F6.z ? Vector3F.Y_UNIT : Vector3F.Z_UNIT);
            Vector3F vector3F7 = vector3F6.minus(vector3F3);
            vector3F5 = vector3F6.minus(vector3F4);
            float f5 = 2.0f / vector3F7.dot(vector3F7);
            float f6 = 2.0f / vector3F5.dot(vector3F5);
            float f7 = f5 * f6 * vector3F7.dot(vector3F5);
            return IDENTITY.plus(Matrix3F.rowMajor(-f5 * vector3F7.x * vector3F7.x - f6 * vector3F5.x * vector3F5.x + f7 * vector3F5.x * vector3F7.x, -f5 * vector3F7.x * vector3F7.y - f6 * vector3F5.x * vector3F5.y + f7 * vector3F5.x * vector3F7.y, -f5 * vector3F7.x * vector3F7.z - f6 * vector3F5.x * vector3F5.z + f7 * vector3F5.x * vector3F7.z, -f5 * vector3F7.y * vector3F7.x - f6 * vector3F5.y * vector3F5.x + f7 * vector3F5.y * vector3F7.x, -f5 * vector3F7.y * vector3F7.y - f6 * vector3F5.y * vector3F5.y + f7 * vector3F5.y * vector3F7.y, -f5 * vector3F7.y * vector3F7.z - f6 * vector3F5.y * vector3F5.z + f7 * vector3F5.y * vector3F7.z, -f5 * vector3F7.z * vector3F7.x - f6 * vector3F5.z * vector3F5.x + f7 * vector3F5.z * vector3F7.x, -f5 * vector3F7.z * vector3F7.y - f6 * vector3F5.z * vector3F5.y + f7 * vector3F5.z * vector3F7.y, -f5 * vector3F7.z * vector3F7.z - f6 * vector3F5.z * vector3F5.z + f7 * vector3F5.z * vector3F7.z));
        }
        float f8 = 1.0f / (1.0f + f3);
        float f9 = f8 * vector3F5.x;
        float f10 = f8 * vector3F5.z;
        float f11 = f9 * vector3F5.y;
        float f12 = f9 * vector3F5.z;
        float f13 = f10 * vector3F5.y;
        return Matrix3F.rowMajor(f3 + f9 * vector3F5.x, f11 - vector3F5.z, f12 + vector3F5.y, f11 + vector3F5.z, f3 + f8 * vector3F5.y * vector3F5.y, f13 - vector3F5.x, f12 - vector3F5.y, f13 + vector3F5.x, f3 + f10 * vector3F5.z);
    }

    protected Matrix3F(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, MatrixType matrixType) {
        this.v00 = f;
        this.v10 = f4;
        this.v20 = f7;
        this.v01 = f2;
        this.v11 = f5;
        this.v21 = f8;
        this.v02 = f3;
        this.v12 = f6;
        this.v22 = f9;
        this.type = matrixType;
    }

    public Matrix4F toMatrix4f() {
        return Matrix4F.rowMajor(this.v00, this.v01, this.v02, 0.0f, this.v10, this.v11, this.v12, 0.0f, this.v20, this.v21, this.v22, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f);
    }

    public Matrix3F plus(Matrix3F matrix3F) {
        return Matrix3F.rowMajor(this.v00 + matrix3F.v00, this.v01 + matrix3F.v01, this.v02 + matrix3F.v02, this.v10 + matrix3F.v10, this.v11 + matrix3F.v11, this.v12 + matrix3F.v12, this.v20 + matrix3F.v20, this.v21 + matrix3F.v21, this.v22 + matrix3F.v22);
    }

    public String toString() {
        return FunctionalUtils.mkString(Arrays.asList(FunctionalUtils.mkString(Arrays.asList(Float.valueOf(this.v00), Float.valueOf(this.v01), Float.valueOf(this.v02)), " "), FunctionalUtils.mkString(Arrays.asList(Float.valueOf(this.v10), Float.valueOf(this.v11), Float.valueOf(this.v12)), " "), FunctionalUtils.mkString(Arrays.asList(Float.valueOf(this.v20), Float.valueOf(this.v21), Float.valueOf(this.v22)), " ")), "\n");
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Matrix3F)) {
            return false;
        }
        Matrix3F matrix3F = (Matrix3F)object;
        if (!matrix3F.canEqual(this)) {
            return false;
        }
        if (Float.compare(this.v00, matrix3F.v00) != 0) {
            return false;
        }
        if (Float.compare(this.v01, matrix3F.v01) != 0) {
            return false;
        }
        if (Float.compare(this.v02, matrix3F.v02) != 0) {
            return false;
        }
        if (Float.compare(this.v10, matrix3F.v10) != 0) {
            return false;
        }
        if (Float.compare(this.v11, matrix3F.v11) != 0) {
            return false;
        }
        if (Float.compare(this.v12, matrix3F.v12) != 0) {
            return false;
        }
        if (Float.compare(this.v20, matrix3F.v20) != 0) {
            return false;
        }
        if (Float.compare(this.v21, matrix3F.v21) != 0) {
            return false;
        }
        return Float.compare(this.v22, matrix3F.v22) == 0;
    }

    public boolean canEqual(Object object) {
        return object instanceof Matrix3F;
    }

    public int hashCode() {
        int n = 1;
        n = n * 31 + Float.floatToIntBits(this.v00);
        n = n * 31 + Float.floatToIntBits(this.v01);
        n = n * 31 + Float.floatToIntBits(this.v02);
        n = n * 31 + Float.floatToIntBits(this.v10);
        n = n * 31 + Float.floatToIntBits(this.v11);
        n = n * 31 + Float.floatToIntBits(this.v12);
        n = n * 31 + Float.floatToIntBits(this.v20);
        n = n * 31 + Float.floatToIntBits(this.v21);
        n = n * 31 + Float.floatToIntBits(this.v22);
        return n;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class MatrixType
    extends Enum<MatrixType> {
        public static final /* enum */ MatrixType IDENTITY = new MatrixType();
        public static final /* enum */ MatrixType TRANSLATION_2D = new MatrixType();
        public static final /* enum */ MatrixType SCALING = new MatrixType();
        public static final /* enum */ MatrixType OTHER = new MatrixType();
        private static final /* synthetic */ MatrixType[] $VALUES;

        public static MatrixType[] values() {
            return (MatrixType[])$VALUES.clone();
        }

        static {
            $VALUES = new MatrixType[]{IDENTITY, TRANSLATION_2D, SCALING, OTHER};
        }
    }
}

