/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.phetcommon.math;

import edu.colorado.phet.common.phetcommon.math.Matrix3F;
import edu.colorado.phet.common.phetcommon.math.vector.Vector3F;
import edu.colorado.phet.common.phetcommon.math.vector.Vector4F;
import edu.colorado.phet.common.phetcommon.util.FunctionalUtils;
import java.nio.FloatBuffer;
import java.util.Arrays;

public class Matrix4F {
    public final float v00;
    public final float v01;
    public final float v02;
    public final float v03;
    public final float v10;
    public final float v11;
    public final float v12;
    public final float v13;
    public final float v20;
    public final float v21;
    public final float v22;
    public final float v23;
    public final float v30;
    public final float v31;
    public final float v32;
    public final float v33;
    public final MatrixType type;
    public static final Matrix4F IDENTITY = Matrix4F.rowMajor(1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, MatrixType.IDENTITY);

    public static Matrix4F fromMatrix3f(Matrix3F matrix3F) {
        return matrix3F.toMatrix4f();
    }

    public static Matrix4F translation(float f, float f2, float f3) {
        return Matrix4F.rowMajor(1.0f, 0.0f, 0.0f, f, 0.0f, 1.0f, 0.0f, f2, 0.0f, 0.0f, 1.0f, f3, 0.0f, 0.0f, 0.0f, 1.0f, MatrixType.TRANSLATION_3D);
    }

    public static Matrix4F translation(Vector3F vector3F) {
        return Matrix4F.translation(vector3F.x, vector3F.y, vector3F.z);
    }

    public static Matrix4F scaling(float f) {
        return Matrix4F.scaling(f, f, f);
    }

    public static Matrix4F scaling(float f, float f2, float f3) {
        return Matrix4F.rowMajor(f, 0.0f, 0.0f, 0.0f, 0.0f, f2, 0.0f, 0.0f, 0.0f, 0.0f, f3, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, MatrixType.SCALING);
    }

    public static Matrix4F rowMajor(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10, float f11, float f12, float f13, float f14, float f15, float f16) {
        return Matrix4F.rowMajor(f, f2, f3, f4, f5, f6, f7, f8, f9, f10, f11, f12, f13, f14, f15, f16, MatrixType.OTHER);
    }

    public static Matrix4F rowMajor(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10, float f11, float f12, float f13, float f14, float f15, float f16, MatrixType matrixType) {
        return new Matrix4F(f, f2, f3, f4, f5, f6, f7, f8, f9, f10, f11, f12, f13, f14, f15, f16, matrixType);
    }

    protected Matrix4F(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10, float f11, float f12, float f13, float f14, float f15, float f16, MatrixType matrixType) {
        this.v00 = f;
        this.v10 = f5;
        this.v20 = f9;
        this.v30 = f13;
        this.v01 = f2;
        this.v11 = f6;
        this.v21 = f10;
        this.v31 = f14;
        this.v02 = f3;
        this.v12 = f7;
        this.v22 = f11;
        this.v32 = f15;
        this.v03 = f4;
        this.v13 = f8;
        this.v23 = f12;
        this.v33 = f16;
        this.type = matrixType;
    }

    public Matrix4F times(Matrix4F matrix4F) {
        MatrixType matrixType = MatrixType.OTHER;
        if (this.type == MatrixType.TRANSLATION_3D && matrix4F.type == MatrixType.TRANSLATION_3D) {
            matrixType = MatrixType.TRANSLATION_3D;
        }
        if (this.type == MatrixType.SCALING && matrix4F.type == MatrixType.SCALING) {
            matrixType = MatrixType.SCALING;
        }
        if (this.type == MatrixType.IDENTITY) {
            matrixType = matrix4F.type;
        }
        if (matrix4F.type == MatrixType.IDENTITY) {
            matrixType = this.type;
        }
        return Matrix4F.rowMajor(this.v00 * matrix4F.v00 + this.v01 * matrix4F.v10 + this.v02 * matrix4F.v20 + this.v03 * matrix4F.v30, this.v00 * matrix4F.v01 + this.v01 * matrix4F.v11 + this.v02 * matrix4F.v21 + this.v03 * matrix4F.v31, this.v00 * matrix4F.v02 + this.v01 * matrix4F.v12 + this.v02 * matrix4F.v22 + this.v03 * matrix4F.v32, this.v00 * matrix4F.v03 + this.v01 * matrix4F.v13 + this.v02 * matrix4F.v23 + this.v03 * matrix4F.v33, this.v10 * matrix4F.v00 + this.v11 * matrix4F.v10 + this.v12 * matrix4F.v20 + this.v13 * matrix4F.v30, this.v10 * matrix4F.v01 + this.v11 * matrix4F.v11 + this.v12 * matrix4F.v21 + this.v13 * matrix4F.v31, this.v10 * matrix4F.v02 + this.v11 * matrix4F.v12 + this.v12 * matrix4F.v22 + this.v13 * matrix4F.v32, this.v10 * matrix4F.v03 + this.v11 * matrix4F.v13 + this.v12 * matrix4F.v23 + this.v13 * matrix4F.v33, this.v20 * matrix4F.v00 + this.v21 * matrix4F.v10 + this.v22 * matrix4F.v20 + this.v23 * matrix4F.v30, this.v20 * matrix4F.v01 + this.v21 * matrix4F.v11 + this.v22 * matrix4F.v21 + this.v23 * matrix4F.v31, this.v20 * matrix4F.v02 + this.v21 * matrix4F.v12 + this.v22 * matrix4F.v22 + this.v23 * matrix4F.v32, this.v20 * matrix4F.v03 + this.v21 * matrix4F.v13 + this.v22 * matrix4F.v23 + this.v23 * matrix4F.v33, this.v30 * matrix4F.v00 + this.v31 * matrix4F.v10 + this.v32 * matrix4F.v20 + this.v33 * matrix4F.v30, this.v30 * matrix4F.v01 + this.v31 * matrix4F.v11 + this.v32 * matrix4F.v21 + this.v33 * matrix4F.v31, this.v30 * matrix4F.v02 + this.v31 * matrix4F.v12 + this.v32 * matrix4F.v22 + this.v33 * matrix4F.v32, this.v30 * matrix4F.v03 + this.v31 * matrix4F.v13 + this.v32 * matrix4F.v23 + this.v33 * matrix4F.v33, matrixType);
    }

    public Vector4F times(Vector4F vector4F) {
        float f = this.v00 * vector4F.getX() + this.v01 * vector4F.getY() + this.v02 * vector4F.getZ() + this.v03 * vector4F.getW();
        float f2 = this.v10 * vector4F.getX() + this.v11 * vector4F.getY() + this.v12 * vector4F.getZ() + this.v13 * vector4F.getW();
        float f3 = this.v20 * vector4F.getX() + this.v21 * vector4F.getY() + this.v22 * vector4F.getZ() + this.v23 * vector4F.getW();
        float f4 = this.v30 * vector4F.getX() + this.v31 * vector4F.getY() + this.v32 * vector4F.getZ() + this.v33 * vector4F.getW();
        return new Vector4F(f, f2, f3, f4);
    }

    public Vector4F timesTranspose(Vector4F vector4F) {
        float f = this.v00 * vector4F.getX() + this.v10 * vector4F.getY() + this.v20 * vector4F.getZ() + this.v30 * vector4F.getW();
        float f2 = this.v01 * vector4F.getX() + this.v11 * vector4F.getY() + this.v21 * vector4F.getZ() + this.v31 * vector4F.getW();
        float f3 = this.v02 * vector4F.getX() + this.v12 * vector4F.getY() + this.v22 * vector4F.getZ() + this.v32 * vector4F.getW();
        float f4 = this.v03 * vector4F.getX() + this.v13 * vector4F.getY() + this.v23 * vector4F.getZ() + this.v33 * vector4F.getW();
        return new Vector4F(f, f2, f3, f4);
    }

    public Vector3F times(Vector3F vector3F) {
        return this.times(new Vector4F(vector3F)).to3F();
    }

    public Vector3F timesTranspose(Vector3F vector3F) {
        return this.timesTranspose(new Vector4F(vector3F)).to3F();
    }

    public float determinant() {
        return this.v03 * this.v12 * this.v21 * this.v30 - this.v02 * this.v13 * this.v21 * this.v30 - this.v03 * this.v11 * this.v22 * this.v30 + this.v01 * this.v13 * this.v22 * this.v30 + this.v02 * this.v11 * this.v23 * this.v30 - this.v01 * this.v12 * this.v23 * this.v30 - this.v03 * this.v12 * this.v20 * this.v31 + this.v02 * this.v13 * this.v20 * this.v31 + this.v03 * this.v10 * this.v22 * this.v31 - this.v00 * this.v13 * this.v22 * this.v31 - this.v02 * this.v10 * this.v23 * this.v31 + this.v00 * this.v12 * this.v23 * this.v31 + this.v03 * this.v11 * this.v20 * this.v32 - this.v01 * this.v13 * this.v20 * this.v32 - this.v03 * this.v10 * this.v21 * this.v32 + this.v00 * this.v13 * this.v21 * this.v32 + this.v01 * this.v10 * this.v23 * this.v32 - this.v00 * this.v11 * this.v23 * this.v32 - this.v02 * this.v11 * this.v20 * this.v33 + this.v01 * this.v12 * this.v20 * this.v33 + this.v02 * this.v10 * this.v21 * this.v33 - this.v00 * this.v12 * this.v21 * this.v33 - this.v01 * this.v10 * this.v22 * this.v33 + this.v00 * this.v11 * this.v22 * this.v33;
    }

    public Matrix4F inverted() {
        float f = this.determinant();
        if (f != 0.0f) {
            return Matrix4F.rowMajor((-this.v31 * this.v22 * this.v13 + this.v21 * this.v32 * this.v13 + this.v31 * this.v12 * this.v23 - this.v11 * this.v32 * this.v23 - this.v21 * this.v12 * this.v33 + this.v11 * this.v22 * this.v33) / f, (this.v31 * this.v22 * this.v03 - this.v21 * this.v32 * this.v03 - this.v31 * this.v02 * this.v23 + this.v01 * this.v32 * this.v23 + this.v21 * this.v02 * this.v33 - this.v01 * this.v22 * this.v33) / f, (-this.v31 * this.v12 * this.v03 + this.v11 * this.v32 * this.v03 + this.v31 * this.v02 * this.v13 - this.v01 * this.v32 * this.v13 - this.v11 * this.v02 * this.v33 + this.v01 * this.v12 * this.v33) / f, (this.v21 * this.v12 * this.v03 - this.v11 * this.v22 * this.v03 - this.v21 * this.v02 * this.v13 + this.v01 * this.v22 * this.v13 + this.v11 * this.v02 * this.v23 - this.v01 * this.v12 * this.v23) / f, (this.v30 * this.v22 * this.v13 - this.v20 * this.v32 * this.v13 - this.v30 * this.v12 * this.v23 + this.v10 * this.v32 * this.v23 + this.v20 * this.v12 * this.v33 - this.v10 * this.v22 * this.v33) / f, (-this.v30 * this.v22 * this.v03 + this.v20 * this.v32 * this.v03 + this.v30 * this.v02 * this.v23 - this.v00 * this.v32 * this.v23 - this.v20 * this.v02 * this.v33 + this.v00 * this.v22 * this.v33) / f, (this.v30 * this.v12 * this.v03 - this.v10 * this.v32 * this.v03 - this.v30 * this.v02 * this.v13 + this.v00 * this.v32 * this.v13 + this.v10 * this.v02 * this.v33 - this.v00 * this.v12 * this.v33) / f, (-this.v20 * this.v12 * this.v03 + this.v10 * this.v22 * this.v03 + this.v20 * this.v02 * this.v13 - this.v00 * this.v22 * this.v13 - this.v10 * this.v02 * this.v23 + this.v00 * this.v12 * this.v23) / f, (-this.v30 * this.v21 * this.v13 + this.v20 * this.v31 * this.v13 + this.v30 * this.v11 * this.v23 - this.v10 * this.v31 * this.v23 - this.v20 * this.v11 * this.v33 + this.v10 * this.v21 * this.v33) / f, (this.v30 * this.v21 * this.v03 - this.v20 * this.v31 * this.v03 - this.v30 * this.v01 * this.v23 + this.v00 * this.v31 * this.v23 + this.v20 * this.v01 * this.v33 - this.v00 * this.v21 * this.v33) / f, (-this.v30 * this.v11 * this.v03 + this.v10 * this.v31 * this.v03 + this.v30 * this.v01 * this.v13 - this.v00 * this.v31 * this.v13 - this.v10 * this.v01 * this.v33 + this.v00 * this.v11 * this.v33) / f, (this.v20 * this.v11 * this.v03 - this.v10 * this.v21 * this.v03 - this.v20 * this.v01 * this.v13 + this.v00 * this.v21 * this.v13 + this.v10 * this.v01 * this.v23 - this.v00 * this.v11 * this.v23) / f, (this.v30 * this.v21 * this.v12 - this.v20 * this.v31 * this.v12 - this.v30 * this.v11 * this.v22 + this.v10 * this.v31 * this.v22 + this.v20 * this.v11 * this.v32 - this.v10 * this.v21 * this.v32) / f, (-this.v30 * this.v21 * this.v02 + this.v20 * this.v31 * this.v02 + this.v30 * this.v01 * this.v22 - this.v00 * this.v31 * this.v22 - this.v20 * this.v01 * this.v32 + this.v00 * this.v21 * this.v32) / f, (this.v30 * this.v11 * this.v02 - this.v10 * this.v31 * this.v02 - this.v30 * this.v01 * this.v12 + this.v00 * this.v31 * this.v12 + this.v10 * this.v01 * this.v32 - this.v00 * this.v11 * this.v32) / f, (-this.v20 * this.v11 * this.v02 + this.v10 * this.v21 * this.v02 + this.v20 * this.v01 * this.v12 - this.v00 * this.v21 * this.v12 - this.v10 * this.v01 * this.v22 + this.v00 * this.v11 * this.v22) / f);
        }
        throw new RuntimeException("Matrix could not be inverted");
    }

    public void writeToBuffer(FloatBuffer floatBuffer) {
        floatBuffer.rewind();
        floatBuffer.put(new float[]{this.v00, this.v10, this.v20, this.v30, this.v01, this.v11, this.v21, this.v31, this.v02, this.v12, this.v22, this.v32, this.v03, this.v13, this.v23, this.v33});
    }

    public String toString() {
        return FunctionalUtils.mkString(Arrays.asList(FunctionalUtils.mkString(Arrays.asList(Float.valueOf(this.v00), Float.valueOf(this.v01), Float.valueOf(this.v02), Float.valueOf(this.v03)), " "), FunctionalUtils.mkString(Arrays.asList(Float.valueOf(this.v10), Float.valueOf(this.v11), Float.valueOf(this.v12), Float.valueOf(this.v13)), " "), FunctionalUtils.mkString(Arrays.asList(Float.valueOf(this.v20), Float.valueOf(this.v21), Float.valueOf(this.v22), Float.valueOf(this.v23)), " "), FunctionalUtils.mkString(Arrays.asList(Float.valueOf(this.v30), Float.valueOf(this.v31), Float.valueOf(this.v32), Float.valueOf(this.v33)), " ")), "\n");
    }

    public Vector3F getTranslation() {
        return new Vector3F(this.v03, this.v13, this.v23);
    }

    public Vector3F getScaling() {
        return new Vector3F(this.v00, this.v11, this.v22);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Matrix4F)) {
            return false;
        }
        Matrix4F matrix4F = (Matrix4F)object;
        if (!matrix4F.canEqual(this)) {
            return false;
        }
        if (Float.compare(this.v00, matrix4F.v00) != 0) {
            return false;
        }
        if (Float.compare(this.v01, matrix4F.v01) != 0) {
            return false;
        }
        if (Float.compare(this.v02, matrix4F.v02) != 0) {
            return false;
        }
        if (Float.compare(this.v03, matrix4F.v03) != 0) {
            return false;
        }
        if (Float.compare(this.v10, matrix4F.v10) != 0) {
            return false;
        }
        if (Float.compare(this.v11, matrix4F.v11) != 0) {
            return false;
        }
        if (Float.compare(this.v12, matrix4F.v12) != 0) {
            return false;
        }
        if (Float.compare(this.v13, matrix4F.v13) != 0) {
            return false;
        }
        if (Float.compare(this.v20, matrix4F.v20) != 0) {
            return false;
        }
        if (Float.compare(this.v21, matrix4F.v21) != 0) {
            return false;
        }
        if (Float.compare(this.v22, matrix4F.v22) != 0) {
            return false;
        }
        if (Float.compare(this.v23, matrix4F.v23) != 0) {
            return false;
        }
        if (Float.compare(this.v30, matrix4F.v30) != 0) {
            return false;
        }
        if (Float.compare(this.v31, matrix4F.v31) != 0) {
            return false;
        }
        if (Float.compare(this.v32, matrix4F.v32) != 0) {
            return false;
        }
        if (Float.compare(this.v33, matrix4F.v33) != 0) {
            return false;
        }
        return !(this.type == null ? matrix4F.type != null : !this.type.equals((Object)matrix4F.type));
    }

    public boolean canEqual(Object object) {
        return object instanceof Matrix4F;
    }

    public int hashCode() {
        int n = 1;
        n = n * 31 + Float.floatToIntBits(this.v00);
        n = n * 31 + Float.floatToIntBits(this.v01);
        n = n * 31 + Float.floatToIntBits(this.v02);
        n = n * 31 + Float.floatToIntBits(this.v03);
        n = n * 31 + Float.floatToIntBits(this.v10);
        n = n * 31 + Float.floatToIntBits(this.v11);
        n = n * 31 + Float.floatToIntBits(this.v12);
        n = n * 31 + Float.floatToIntBits(this.v13);
        n = n * 31 + Float.floatToIntBits(this.v20);
        n = n * 31 + Float.floatToIntBits(this.v21);
        n = n * 31 + Float.floatToIntBits(this.v22);
        n = n * 31 + Float.floatToIntBits(this.v23);
        n = n * 31 + Float.floatToIntBits(this.v30);
        n = n * 31 + Float.floatToIntBits(this.v31);
        n = n * 31 + Float.floatToIntBits(this.v32);
        n = n * 31 + Float.floatToIntBits(this.v33);
        n = n * 31 + (this.type == null ? 0 : this.type.hashCode());
        return n;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class MatrixType
    extends Enum<MatrixType> {
        public static final /* enum */ MatrixType IDENTITY = new MatrixType();
        public static final /* enum */ MatrixType TRANSLATION_3D = new MatrixType();
        public static final /* enum */ MatrixType SCALING = new MatrixType();
        public static final /* enum */ MatrixType OTHER = new MatrixType();
        private static final /* synthetic */ MatrixType[] $VALUES;

        public static MatrixType[] values() {
            return (MatrixType[])$VALUES.clone();
        }

        static {
            $VALUES = new MatrixType[]{IDENTITY, TRANSLATION_3D, SCALING, OTHER};
        }
    }
}

