/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.phetcommon.math;

import edu.colorado.phet.common.phetcommon.util.FunctionalUtils;
import edu.colorado.phet.common.phetcommon.util.function.VoidFunction1;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Permutation {
    private final int[] indices;

    public static Permutation identity(int n) {
        assert (n >= 0);
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            nArray[i] = i;
        }
        return new Permutation(nArray);
    }

    public static List<Permutation> permutations(int n) {
        final ArrayList<Permutation> arrayList = new ArrayList<Permutation>();
        Permutation.forEachPermutation(FunctionalUtils.rangeInclusive(0, n - 1), new VoidFunction1<List<Integer>>(){

            @Override
            public void apply(List<Integer> list) {
                arrayList.add(new Permutation(list));
            }
        });
        return arrayList;
    }

    public Permutation(int[] nArray) {
        this.indices = nArray;
    }

    public Permutation(List<Integer> list) {
        this.indices = new int[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            this.indices[i] = list.get(i);
        }
    }

    public <T> List<T> apply(List<T> list) {
        if (list.size() != this.indices.length) {
            throw new IllegalArgumentException("Permutation length " + this.size() + " not equal to list length " + list.size());
        }
        ArrayList<T> arrayList = new ArrayList<T>(list.size());
        for (int i = 0; i < list.size(); ++i) {
            arrayList.add(list.get(this.indices[i]));
        }
        return arrayList;
    }

    public int apply(int n) {
        return this.indices[n];
    }

    public int size() {
        return this.indices.length;
    }

    public Permutation inverted() {
        int[] nArray = new int[this.size()];
        for (int i = 0; i < this.size(); ++i) {
            nArray[this.indices[i]] = i;
        }
        return new Permutation(nArray);
    }

    public List<Permutation> withIndicesPermuted(final List<Integer> list) {
        final ArrayList<Permutation> arrayList = new ArrayList<Permutation>();
        Permutation.forEachPermutation(list, new VoidFunction1<List<Integer>>(){

            @Override
            public void apply(List<Integer> list2) {
                int[] nArray = Permutation.this.indices;
                int[] nArray2 = new int[nArray.length];
                System.arraycopy(nArray, 0, nArray2, 0, nArray.length);
                for (int i = 0; i < list.size(); ++i) {
                    nArray2[((Integer)list.get((int)i)).intValue()] = nArray[list2.get(i)];
                }
                arrayList.add(new Permutation(nArray2));
            }
        });
        return arrayList;
    }

    public String toString() {
        return Arrays.toString(this.indices);
    }

    public static <T> void forEachPermutation(List<T> list, VoidFunction1<List<T>> voidFunction1) {
        Permutation.forEachPermutation(list, new ArrayList(), voidFunction1);
    }

    private static <T> void forEachPermutation(List<T> list, List<T> list2, VoidFunction1<List<T>> voidFunction1) {
        if (list.isEmpty()) {
            voidFunction1.apply(list2);
        } else {
            for (final T t : list) {
                Permutation.forEachPermutation(new ArrayList<T>(list){
                    {
                        super(collection);
                        this.remove(t);
                    }
                }, new ArrayList<T>(list2){
                    {
                        super(collection);
                        this.add(t);
                    }
                }, voidFunction1);
            }
        }
    }
}

