/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.phetcommon.math;

import edu.colorado.phet.common.phetcommon.math.Ray3F;
import edu.colorado.phet.common.phetcommon.math.vector.Vector3F;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SphereF {
    public final Vector3F center;
    public final float radius;

    public SphereF(Vector3F vector3F, float f) {
        this.center = vector3F;
        this.radius = f;
    }

    public SphereIntersectionResult intersect(Ray3F ray3F, float f) {
        float f2;
        Vector3F vector3F = ray3F.dir;
        Vector3F vector3F2 = ray3F.pos;
        Vector3F vector3F3 = vector3F2.minus(this.center);
        float f3 = vector3F.dot(vector3F3);
        float f4 = 4.0f * f3 * f3 - 4.0f * ((f2 = vector3F3.magnitudeSquared()) - this.radius * this.radius);
        if (f4 < f) {
            return null;
        }
        float f5 = vector3F.dot(this.center) - vector3F.dot(vector3F2);
        float f6 = (float)(Math.sqrt(f4) / 2.0);
        float f7 = f5 - f6;
        float f8 = f5 + f6;
        if (f8 < f) {
            return null;
        }
        Vector3F vector3F4 = ray3F.pointAtDistance(f8);
        Vector3F vector3F5 = vector3F4.minus(this.center).normalized();
        if (f7 < f) {
            return new SphereIntersectionResult(f8, vector3F4, vector3F5.negated(), false);
        }
        Vector3F vector3F6 = ray3F.pointAtDistance(f7);
        Vector3F vector3F7 = vector3F6.minus(this.center).normalized();
        return new SphereIntersectionResult(f7, vector3F6, vector3F7, true);
    }

    public List<SphereIntersectionResult> intersections(Ray3F ray3F, float f) {
        float f2;
        ArrayList<SphereIntersectionResult> arrayList = new ArrayList<SphereIntersectionResult>();
        Vector3F vector3F = ray3F.dir;
        Vector3F vector3F2 = ray3F.pos;
        Vector3F vector3F3 = vector3F2.minus(this.center);
        float f3 = vector3F.dot(vector3F3);
        float f4 = 4.0f * f3 * f3 - 4.0f * ((f2 = vector3F3.magnitudeSquared()) - this.radius * this.radius);
        if (f4 < f) {
            return arrayList;
        }
        float f5 = vector3F.dot(this.center) - vector3F.dot(vector3F2);
        float f6 = (float)(Math.sqrt(f4) / 2.0);
        float f7 = f5 - f6;
        float f8 = f5 + f6;
        if (f8 < f) {
            return arrayList;
        }
        Vector3F vector3F4 = ray3F.pointAtDistance(f8);
        Vector3F vector3F5 = vector3F4.minus(this.center).normalized();
        Vector3F vector3F6 = ray3F.pointAtDistance(f7);
        Vector3F vector3F7 = vector3F6.minus(this.center).normalized();
        SphereIntersectionResult sphereIntersectionResult = new SphereIntersectionResult(f8, vector3F4, vector3F5.negated(), false);
        SphereIntersectionResult sphereIntersectionResult2 = new SphereIntersectionResult(f7, vector3F6, vector3F7, true);
        if (f7 < f) {
            return Arrays.asList(sphereIntersectionResult, sphereIntersectionResult2);
        }
        return Arrays.asList(sphereIntersectionResult2, sphereIntersectionResult);
    }

    public Vector3F getCenter() {
        return this.center;
    }

    public double getRadius() {
        return this.radius;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof SphereF)) {
            return false;
        }
        SphereF sphereF = (SphereF)object;
        if (!sphereF.canEqual(this)) {
            return false;
        }
        if (this.getCenter() == null ? sphereF.getCenter() != null : !this.getCenter().equals(sphereF.getCenter())) {
            return false;
        }
        return Double.compare(this.getRadius(), sphereF.getRadius()) == 0;
    }

    public boolean canEqual(Object object) {
        return object instanceof SphereF;
    }

    public int hashCode() {
        int n = 1;
        long l = Double.doubleToLongBits(this.getRadius());
        n = n * 31 + (this.getCenter() == null ? 0 : this.getCenter().hashCode());
        n = n * 31 + (int)(l >>> 32 ^ l);
        return n;
    }

    public String toString() {
        return "SphereF(center=" + this.getCenter() + ", radius=" + this.getRadius() + ")";
    }

    public static class SphereIntersectionResult {
        public float distance;
        public Vector3F hitPoint;
        public Vector3F normal;
        public boolean fromOutside;

        public SphereIntersectionResult(float f, Vector3F vector3F, Vector3F vector3F2, boolean bl) {
            this.distance = f;
            this.hitPoint = vector3F;
            this.normal = vector3F2;
            this.fromOutside = bl;
        }

        public Vector3F getHitPoint() {
            return this.hitPoint;
        }
    }
}

