/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.phetcommon.math.vector;

import edu.colorado.phet.common.phetcommon.math.vector.AbstractVector2F;

public class Vector2F
extends AbstractVector2F {
    public final float x;
    public final float y;
    public static final Vector2F ZERO = new Vector2F();
    public static final Vector2F X_UNIT = new Vector2F(1.0f, 0.0f);
    public static final Vector2F Y_UNIT = new Vector2F(0.0f, 1.0f);

    public Vector2F() {
        this(0.0f, 0.0f);
    }

    public Vector2F(float f, float f2) {
        this.x = f;
        this.y = f2;
    }

    public Vector2F(double d, double d2) {
        this.x = (float)d;
        this.y = (float)d2;
    }

    public float getY() {
        return this.y;
    }

    public float getX() {
        return this.x;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Vector2F)) {
            return false;
        }
        Vector2F vector2F = (Vector2F)object;
        if (!vector2F.canEqual(this)) {
            return false;
        }
        if (Float.compare(this.getX(), vector2F.getX()) != 0) {
            return false;
        }
        return Float.compare(this.getY(), vector2F.getY()) == 0;
    }

    public boolean canEqual(Object object) {
        return object instanceof Vector2F;
    }

    public int hashCode() {
        int n = 1;
        n = n * 31 + Float.floatToIntBits(this.getX());
        n = n * 31 + Float.floatToIntBits(this.getY());
        return n;
    }

    public String toString() {
        return "Vector2F(x=" + this.getX() + ", y=" + this.getY() + ")";
    }
}

