/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.phetcommon.math.vector;

import edu.colorado.phet.common.phetcommon.math.vector.AbstractVector3D;

public class Vector3D
extends AbstractVector3D {
    public final double x;
    public final double y;
    public final double z;
    public static final Vector3D ZERO = new Vector3D();
    public static final Vector3D X_UNIT = new Vector3D(1.0, 0.0, 0.0);
    public static final Vector3D Y_UNIT = new Vector3D(0.0, 1.0, 0.0);
    public static final Vector3D Z_UNIT = new Vector3D(0.0, 0.0, 1.0);

    public Vector3D() {
        this(0.0, 0.0, 0.0);
    }

    public Vector3D(double d, double d2, double d3) {
        this.x = d;
        this.y = d2;
        this.z = d3;
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public double getZ() {
        return this.z;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Vector3D)) {
            return false;
        }
        Vector3D vector3D = (Vector3D)object;
        if (!vector3D.canEqual(this)) {
            return false;
        }
        if (Double.compare(this.getX(), vector3D.getX()) != 0) {
            return false;
        }
        if (Double.compare(this.getY(), vector3D.getY()) != 0) {
            return false;
        }
        return Double.compare(this.getZ(), vector3D.getZ()) == 0;
    }

    public boolean canEqual(Object object) {
        return object instanceof Vector3D;
    }

    public int hashCode() {
        int n = 1;
        long l = Double.doubleToLongBits(this.getX());
        long l2 = Double.doubleToLongBits(this.getY());
        long l3 = Double.doubleToLongBits(this.getZ());
        n = n * 31 + (int)(l >>> 32 ^ l);
        n = n * 31 + (int)(l2 >>> 32 ^ l2);
        n = n * 31 + (int)(l3 >>> 32 ^ l3);
        return n;
    }

    public String toString() {
        return "Vector3D(x=" + this.getX() + ", y=" + this.getY() + ", z=" + this.getZ() + ")";
    }
}

