/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.phetcommon.math.vector;

import edu.colorado.phet.common.phetcommon.math.QuaternionF;
import edu.colorado.phet.common.phetcommon.math.vector.AbstractVector3F;
import edu.colorado.phet.common.phetcommon.math.vector.Vector2F;

public class Vector3F
extends AbstractVector3F {
    public final float x;
    public final float y;
    public final float z;
    public static final Vector3F ZERO = new Vector3F();
    public static final Vector3F X_UNIT = new Vector3F(1.0f, 0.0f, 0.0f);
    public static final Vector3F Y_UNIT = new Vector3F(0.0f, 1.0f, 0.0f);
    public static final Vector3F Z_UNIT = new Vector3F(0.0f, 0.0f, 1.0f);

    public Vector3F() {
        this(0.0f, 0.0f, 0.0f);
    }

    public Vector3F(Vector2F vector2F) {
        this.x = vector2F.x;
        this.y = vector2F.y;
        this.z = 0.0f;
    }

    public Vector3F(float f, float f2, float f3) {
        this.x = f;
        this.y = f2;
        this.z = f3;
    }

    public Vector3F(double d, double d2, double d3) {
        this.x = (float)d;
        this.y = (float)d2;
        this.z = (float)d3;
    }

    public float getX() {
        return this.x;
    }

    public float getY() {
        return this.y;
    }

    public float getZ() {
        return this.z;
    }

    public static Vector3F slerp(Vector3F vector3F, Vector3F vector3F2, float f) {
        return QuaternionF.slerp(new QuaternionF(), QuaternionF.getRotationQuaternion(vector3F, vector3F2), f).times(vector3F);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Vector3F)) {
            return false;
        }
        Vector3F vector3F = (Vector3F)object;
        if (!vector3F.canEqual(this)) {
            return false;
        }
        if (Float.compare(this.getX(), vector3F.getX()) != 0) {
            return false;
        }
        if (Float.compare(this.getY(), vector3F.getY()) != 0) {
            return false;
        }
        return Float.compare(this.getZ(), vector3F.getZ()) == 0;
    }

    public boolean canEqual(Object object) {
        return object instanceof Vector3F;
    }

    public int hashCode() {
        int n = 1;
        n = n * 31 + Float.floatToIntBits(this.getX());
        n = n * 31 + Float.floatToIntBits(this.getY());
        n = n * 31 + Float.floatToIntBits(this.getZ());
        return n;
    }

    public String toString() {
        return "Vector3F(x=" + this.getX() + ", y=" + this.getY() + ", z=" + this.getZ() + ")";
    }
}

