/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.phetcommon.math.vector;

import edu.colorado.phet.common.phetcommon.math.vector.AbstractVector4F;
import edu.colorado.phet.common.phetcommon.math.vector.Vector3F;

public class Vector4F
extends AbstractVector4F {
    public final float x;
    public final float y;
    public final float z;
    public final float w;
    public static final Vector4F ZERO = new Vector4F();
    public static final Vector4F X_UNIT = new Vector4F(1.0f, 0.0f, 0.0f, 0.0f);
    public static final Vector4F Y_UNIT = new Vector4F(0.0f, 1.0f, 0.0f, 0.0f);
    public static final Vector4F Z_UNIT = new Vector4F(0.0f, 0.0f, 1.0f, 0.0f);
    public static final Vector4F W_UNIT = new Vector4F(0.0f, 0.0f, 0.0f, 1.0f);

    public Vector4F() {
        this(0.0f, 0.0f, 0.0f);
    }

    public Vector4F(Vector3F vector3F) {
        this(vector3F.getX(), vector3F.getY(), vector3F.getZ());
    }

    public Vector4F(float f, float f2, float f3) {
        this(f, f2, f3, 1.0f);
    }

    public Vector4F(float f, float f2, float f3, float f4) {
        this.x = f;
        this.y = f2;
        this.z = f3;
        this.w = f4;
    }

    public float getX() {
        return this.x;
    }

    public float getY() {
        return this.y;
    }

    public float getZ() {
        return this.z;
    }

    public float getW() {
        return this.w;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Vector4F)) {
            return false;
        }
        Vector4F vector4F = (Vector4F)object;
        if (!vector4F.canEqual(this)) {
            return false;
        }
        if (Float.compare(this.getX(), vector4F.getX()) != 0) {
            return false;
        }
        if (Float.compare(this.getY(), vector4F.getY()) != 0) {
            return false;
        }
        if (Float.compare(this.getZ(), vector4F.getZ()) != 0) {
            return false;
        }
        return Float.compare(this.getW(), vector4F.getW()) == 0;
    }

    public boolean canEqual(Object object) {
        return object instanceof Vector4F;
    }

    public int hashCode() {
        int n = 1;
        n = n * 31 + Float.floatToIntBits(this.getX());
        n = n * 31 + Float.floatToIntBits(this.getY());
        n = n * 31 + Float.floatToIntBits(this.getZ());
        n = n * 31 + Float.floatToIntBits(this.getW());
        return n;
    }

    public String toString() {
        return "Vector4F(x=" + this.getX() + ", y=" + this.getY() + ", z=" + this.getZ() + ", w=" + this.getW() + ")";
    }
}

