/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.piccolophet.nodes.kit;

import edu.colorado.phet.common.phetcommon.model.property.Property;
import edu.colorado.phet.common.phetcommon.simsharing.SimSharingManager;
import edu.colorado.phet.common.phetcommon.simsharing.messages.IParameterKey;
import edu.colorado.phet.common.phetcommon.simsharing.messages.IUserComponent;
import edu.colorado.phet.common.phetcommon.simsharing.messages.Parameter;
import edu.colorado.phet.common.phetcommon.simsharing.messages.ParameterKeys;
import edu.colorado.phet.common.phetcommon.simsharing.messages.ParameterSet;
import edu.colorado.phet.common.phetcommon.simsharing.messages.UserActions;
import edu.colorado.phet.common.phetcommon.simsharing.messages.UserComponentChain;
import edu.colorado.phet.common.phetcommon.simsharing.messages.UserComponentTypes;
import edu.colorado.phet.common.phetcommon.simsharing.messages.UserComponents;
import edu.colorado.phet.common.phetcommon.util.Option;
import edu.colorado.phet.common.phetcommon.util.function.VoidFunction1;
import edu.colorado.phet.common.piccolophet.nodes.kit.NextKitButton;
import edu.colorado.phet.common.piccolophet.nodes.kit.PreviousKitButton;
import edu.umd.cs.piccolo.PNode;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class KitControlNode
extends PNode {
    public KitControlNode(IUserComponent iUserComponent, int n, Property<Integer> property, Option<PNode> option, double d) {
        this(iUserComponent, n, property, option, d, Color.orange);
    }

    public KitControlNode(final IUserComponent iUserComponent, final int n, final Property<Integer> property, Option<PNode> option, double d, Color color) {
        final NextKitButton nextKitButton = new NextKitButton(color){
            {
                super(color);
                this.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        int n = (Integer)property.get() + 1;
                        SimSharingManager.sendUserMessage(UserComponentChain.chain(iUserComponent, UserComponents.nextButton), UserComponentTypes.button, UserActions.pressed, new ParameterSet(new Parameter((IParameterKey)ParameterKeys.selectedKit, n)));
                        property.set(n);
                    }
                });
                property.addObserver(new VoidFunction1<Integer>(){

                    @Override
                    public void apply(Integer n) {
                        this.setEnabled((Integer)property.get() < n - 1);
                    }
                });
            }
        };
        this.addChild(nextKitButton);
        PreviousKitButton previousKitButton = new PreviousKitButton(color){
            {
                super(color);
                if (this.getFullBounds().getMaxX() > nextKitButton.getFullBounds().getMinX()) {
                    this.setOffset(nextKitButton.getFullBounds().getMinX() - 2.0, this.getOffset().getY());
                }
                this.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        int n = (Integer)property.get() - 1;
                        SimSharingManager.sendUserMessage(UserComponentChain.chain(iUserComponent, UserComponents.previousButton), UserComponentTypes.button, UserActions.pressed, new ParameterSet(new Parameter((IParameterKey)ParameterKeys.selectedKit, n)));
                        property.set(n);
                    }
                });
                property.addObserver(new VoidFunction1<Integer>(){

                    @Override
                    public void apply(Integer n) {
                        this.setEnabled((Integer)property.get() > 0);
                    }
                });
            }
        };
        this.addChild(previousKitButton);
        if (option.isSome()) {
            PNode pNode = option.get();
            this.addChild(pNode);
            pNode.setOffset(previousKitButton.getFullBounds().getMaxX() + d, previousKitButton.getFullBounds().getCenterY() - pNode.getFullBounds().getHeight() / 2.0);
            nextKitButton.setOffset(pNode.getFullBounds().getMaxX() + d, 0.0);
        } else {
            nextKitButton.setOffset(previousKitButton.getFullBounds().getMaxX() + d * 2.0, 0.0);
        }
        if (n == 1) {
            previousKitButton.setVisible(false);
            previousKitButton.setPickable(false);
            previousKitButton.setChildrenPickable(false);
            nextKitButton.setVisible(false);
            nextKitButton.setPickable(false);
            nextKitButton.setChildrenPickable(false);
        }
    }
}

