/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.lwjglphet;

import edu.colorado.phet.common.phetcommon.model.property.Property;
import edu.colorado.phet.common.phetcommon.util.SimpleObserver;
import java.awt.Dimension;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;

public abstract class CanvasTransform {
    public final Property<AffineTransform> transform = new Property<Object>(null);

    public abstract float getFieldOfViewYFactor();

    public Rectangle2D getTransformedBounds(Rectangle2D rectangle2D) {
        return this.transform.get().createTransformedShape(rectangle2D).getBounds2D();
    }

    public static float getStageCenteringFieldOfViewYFactor(Dimension dimension, Dimension dimension2) {
        double d = dimension.getWidth() / dimension2.getWidth();
        double d2 = dimension.getHeight() / dimension2.getHeight();
        if (d == 0.0 || d2 == 0.0) {
            return 1.0f;
        }
        return d2 > d ? (float)(d2 / d) : 1.0f;
    }

    public static AffineTransform getStageCenteringTransform(Dimension dimension, Dimension dimension2) {
        double d;
        double d2 = dimension.getWidth() / dimension2.getWidth();
        double d3 = d2 < (d = dimension.getHeight() / dimension2.getHeight()) ? d2 : d;
        d3 = d3 <= 0.0 ? 1.0 : d3;
        AffineTransform affineTransform = new AffineTransform();
        double d4 = d3 * dimension2.getWidth();
        double d5 = d3 * dimension2.getHeight();
        affineTransform.translate(dimension.getWidth() / 2.0 - d4 / 2.0, dimension.getHeight() / 2.0 - d5 / 2.0);
        affineTransform.scale(d3, d3);
        return affineTransform;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class StageCenteringCanvasTransform
    extends CanvasTransform {
        private final Dimension stageSize;
        private final Property<Dimension> canvasSize;

        public StageCenteringCanvasTransform(final Property<Dimension> property, final Dimension dimension) {
            this.canvasSize = property;
            this.stageSize = dimension;
            property.addObserver(new SimpleObserver(){

                public void update() {
                    StageCenteringCanvasTransform.this.transform.set(CanvasTransform.getStageCenteringTransform((Dimension)property.get(), dimension));
                }
            });
        }

        @Override
        public float getFieldOfViewYFactor() {
            return StageCenteringCanvasTransform.getStageCenteringFieldOfViewYFactor(this.canvasSize.get(), this.stageSize);
        }
    }
}

