/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.lwjglphet;

import edu.colorado.phet.lwjglphet.LWJGLTab;
import edu.colorado.phet.lwjglphet.StartupUtils;
import edu.colorado.phet.lwjglphet.utils.LWJGLUtils;
import java.awt.Canvas;
import java.awt.Frame;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.lwjgl.LWJGLException;
import org.lwjgl.opengl.Display;
import org.lwjgl.opengl.PixelFormat;

public class LWJGLCanvas
extends Canvas {
    private Thread renderThread;
    private boolean running;
    private boolean tabDirty = true;
    private LWJGLTab activeTab = null;
    private static LWJGLCanvas instance = null;
    private static ConcurrentLinkedQueue<Runnable> taskQueue = new ConcurrentLinkedQueue();
    private final Frame parentFrame;

    public static synchronized LWJGLCanvas getCanvasInstance(Frame frame) {
        if (instance == null) {
            instance = new LWJGLCanvas(frame);
        }
        return instance;
    }

    public static void addTask(Runnable runnable) {
        taskQueue.add(runnable);
    }

    private LWJGLCanvas(Frame frame) {
        this.parentFrame = frame;
        this.setFocusable(true);
        this.requestFocus();
        this.setIgnoreRepaint(true);
        System.setProperty("org.lwjgl.opengl.Display.allowSoftwareOpenGL", "true");
    }

    public void addNotify() {
        super.addNotify();
        this.initialize();
    }

    public final void removeNotify() {
        this.running = false;
        try {
            this.renderThread.join();
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
        super.removeNotify();
    }

    public void switchToTab(final LWJGLTab lWJGLTab) {
        LWJGLCanvas.addTask(new Runnable(){

            public void run() {
                if (LWJGLCanvas.this.activeTab != null) {
                    LWJGLCanvas.this.activeTab.stop();
                }
                LWJGLCanvas.this.activeTab = lWJGLTab;
                LWJGLCanvas.this.tabDirty = true;
            }
        });
    }

    public void initialize() {
        this.renderThread = new Thread("PhET LWJGL Main Loop Thread"){

            public void run() {
                LWJGLCanvas.this.running = true;
                try {
                    int n = StartupUtils.getMaximumAntialiasingSamples();
                    Display.setParent(LWJGLCanvas.this);
                    Display.create(new PixelFormat(24, 8, 24, 0, Math.min(4, n)));
                    while (LWJGLCanvas.this.running) {
                        while (!taskQueue.isEmpty()) {
                            ((Runnable)taskQueue.poll()).run();
                        }
                        if (LWJGLCanvas.this.activeTab == null) continue;
                        if (LWJGLCanvas.this.tabDirty) {
                            LWJGLCanvas.this.activeTab.start();
                            LWJGLCanvas.this.tabDirty = false;
                        }
                        LWJGLCanvas.this.activeTab.loop();
                    }
                    Display.destroy();
                }
                catch (LWJGLException lWJGLException) {
                    LWJGLUtils.showErrorDialog(LWJGLCanvas.this.parentFrame, lWJGLException);
                    lWJGLException.printStackTrace();
                }
            }
        };
        this.renderThread.start();
    }
}

