/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.lwjglphet;

import edu.colorado.phet.common.phetcommon.model.property.Property;
import edu.colorado.phet.common.phetcommon.util.SimpleObserver;
import edu.colorado.phet.common.piccolophet.PhetTabbedPane;
import edu.colorado.phet.lwjglphet.LWJGLCanvas;
import java.awt.Dimension;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import org.lwjgl.opengl.GL11;

public abstract class LWJGLTab
implements PhetTabbedPane.TabbedModule.Tab {
    private final LWJGLCanvas canvas;
    private final String title;
    public final Property<Boolean> active = new Property<Boolean>(false);
    public final Property<Dimension> canvasSize;
    public Dimension initialCanvasSize;

    public LWJGLTab(final LWJGLCanvas lWJGLCanvas, String string) {
        this.canvas = lWJGLCanvas;
        this.title = string;
        this.active.addObserver(new SimpleObserver(){

            public void update() {
                if (LWJGLTab.this.active.get().booleanValue()) {
                    lWJGLCanvas.switchToTab(LWJGLTab.this);
                }
            }
        }, false);
        this.canvasSize = new Property<Dimension>(lWJGLCanvas.getSize());
        lWJGLCanvas.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent componentEvent) {
                final Dimension dimension = lWJGLCanvas.getSize();
                LWJGLCanvas.addTask(new Runnable(){

                    public void run() {
                        LWJGLTab.this.canvasSize.set(dimension);
                    }
                });
            }
        });
        this.canvasSize.addObserver(new SimpleObserver(){

            public void update() {
                if (LWJGLTab.this.initialCanvasSize == null && LWJGLTab.this.canvasSize.get().getWidth() != 0.0 && LWJGLTab.this.canvasSize.get().getHeight() != 0.0) {
                    LWJGLTab.this.initialCanvasSize = LWJGLTab.this.canvasSize.get();
                }
            }
        });
    }

    public abstract void start();

    public abstract void stop();

    public abstract void loop();

    public String getTitle() {
        return this.title;
    }

    public void setActive(boolean bl) {
        this.active.set(bl);
    }

    public int getCanvasWidth() {
        return this.canvasSize.get().width;
    }

    public int getCanvasHeight() {
        return this.canvasSize.get().height;
    }

    public LWJGLCanvas getCanvas() {
        return this.canvas;
    }

    public Dimension getCanvasSize() {
        return this.canvasSize.get();
    }

    public void setupGuiTransformations() {
        GL11.glMatrixMode(5889);
        GL11.glLoadIdentity();
        GL11.glOrtho(0.0, this.getCanvasWidth(), this.getCanvasHeight(), 0.0, 1.0, -1.0);
        GL11.glMatrixMode(5888);
        GL11.glLoadIdentity();
    }
}

