/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.lwjglphet;

import edu.colorado.phet.common.phetcommon.math.vector.Vector2F;
import edu.colorado.phet.common.phetcommon.util.function.VoidFunction0;
import edu.colorado.phet.lwjglphet.LWJGLRepaintManager;
import edu.colorado.phet.lwjglphet.TextureImage;
import edu.colorado.phet.lwjglphet.contrib.LWJGLSwingEventHandler;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import javax.swing.JComponent;
import javax.swing.RepaintManager;
import javax.swing.SwingUtilities;
import org.lwjgl.input.Mouse;

public class SwingImage
extends TextureImage {
    private final JComponent component;
    private final LWJGLSwingEventHandler swingEventHandler;
    private volatile boolean dirty = true;

    public SwingImage(int n, int n2, boolean bl, int n3, int n4, AffineTransform affineTransform, JComponent jComponent) {
        super(n, n2, bl, n3, n4, affineTransform);
        this.component = jComponent;
        this.swingEventHandler = new LWJGLSwingEventHandler(jComponent);
        this.init();
    }

    private void init() {
        this.initRepaintManager();
        this.component.setDoubleBuffered(false);
        this.refreshImage();
        this.component.putClientProperty("!@#%^&*", new VoidFunction0(){

            public void apply() {
                SwingImage.this.dirty = true;
            }
        });
    }

    public void handleMouseEvent(int n, int n2) {
        Vector2F vector2F = this.localToComponentCoordinates(new Vector2F(n, n2));
        final double d = vector2F.x;
        final double d2 = vector2F.y;
        final int n3 = Mouse.getEventButton();
        final boolean bl = Mouse.getEventButtonState();
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                if (n3 == -1) {
                    SwingImage.this.swingEventHandler.sendAWTMouseEvent((int)d, (int)d2, false, 0);
                } else {
                    SwingImage.this.swingEventHandler.sendAWTMouseEvent((int)d, (int)d2, bl, SwingImage.this.swingEventHandler.getSwingButtonIndex(n3));
                }
            }
        });
    }

    public void update() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                if (SwingImage.this.dirty) {
                    SwingImage.this.refreshImage();
                    SwingImage.this.dirty = false;
                }
            }
        });
    }

    public void paint(Graphics2D graphics2D) {
        graphics2D.setBackground(new Color(0.0f, 0.0f, 0.0f, 0.0f));
        graphics2D.clearRect(0, 0, this.getWidth(), this.getHeight());
        this.component.validate();
        this.component.setSize(this.component.getPreferredSize());
        SwingImage.layoutComponent(this.component);
        this.component.printAll(graphics2D);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void layoutComponent(Component component) {
        Object object = component.getTreeLock();
        synchronized (object) {
            component.doLayout();
            if (component instanceof Container) {
                for (Component component2 : ((Container)component).getComponents()) {
                    SwingImage.layoutComponent(component2);
                }
            }
        }
    }

    private void initRepaintManager() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                RepaintManager repaintManager = RepaintManager.currentManager(SwingImage.this.component);
                if (!(repaintManager instanceof LWJGLRepaintManager)) {
                    RepaintManager.setCurrentManager(new LWJGLRepaintManager());
                }
            }
        });
    }

    public Component componentAt(int n, int n2) {
        return this.swingEventHandler.componentAt(n, n2);
    }
}

