/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.lwjglphet.contrib;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Container;
import java.awt.Point;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.JRootPane;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;

public class LWJGLSwingEventHandler {
    private Component lastComponent;
    private Component grabbedMouse;
    private int grabbedMouseButton;
    private int downX = 0;
    private int downY = 0;
    private long lastClickTime = 0L;
    private int clickCount = 0;
    private boolean useConvertPoint = true;
    private final JComponent component;
    private boolean focusCleared = false;

    public LWJGLSwingEventHandler(JComponent jComponent) {
        this.component = jComponent;
    }

    public int getSwingButtonIndex(int n) {
        switch (n) {
            case 0: {
                return 1;
            }
            case 1: {
                return 2;
            }
            case 2: {
                return 3;
            }
        }
        return 0;
    }

    private Point convertPoint(Component component, int n, int n2, Component component2) {
        if (this.useConvertPoint && component != null && component2 != null) {
            try {
                return SwingUtilities.convertPoint(component, n, n2, component2);
            }
            catch (Throwable throwable) {
                this.useConvertPoint = false;
            }
        }
        if (component2 != null) {
            while (component2 != component) {
                n -= component2.getX();
                n2 -= component2.getY();
                if (component2.getParent() == null) break;
                component2 = component2.getParent();
            }
        }
        return new Point(n, n2);
    }

    public void sendAWTMouseEvent(int n, int n2, boolean bl, int n3) {
        Component component = this.componentAt(n, n2, this.component, false);
        if (component == null) {
            component = this.component;
        }
        int n4 = n3 > 0 ? (bl ? 501 : 502) : (this.getButtonMask(0) == 0 ? 503 : 506);
        long l = System.currentTimeMillis();
        if (this.lastComponent != component) {
            Point point;
            while (!(this.lastComponent == null || component != null && SwingUtilities.isDescendingFrom(component, this.lastComponent))) {
                point = this.convertPoint(this.component, n, n2, this.lastComponent);
                this.sendExitedEvent(this.lastComponent, this.getCurrentModifiers(n3), point);
                this.lastComponent = this.lastComponent.getParent();
            }
            point = this.convertPoint(this.component, n, n2, this.lastComponent);
            if (this.lastComponent == null) {
                this.lastComponent = this.component;
            }
            this.sendEnteredEvent(component, this.lastComponent, this.getCurrentModifiers(n3), point);
            this.lastComponent = component;
            this.downX = Integer.MIN_VALUE;
            this.downY = Integer.MIN_VALUE;
            this.lastClickTime = 0L;
        }
        if (component != null) {
            boolean bl2 = false;
            Component component2 = this.componentAt(n, n2, this.component, true);
            if (component2 == null) {
                component2 = component;
            }
            if (n3 > 0) {
                if (bl) {
                    this.grabbedMouse = component;
                    this.grabbedMouseButton = n3;
                    this.downX = n;
                    this.downY = n2;
                    component2.requestFocus();
                } else if (this.grabbedMouseButton == n3 && this.grabbedMouse != null) {
                    component = this.grabbedMouse;
                    this.grabbedMouse = null;
                    if (Math.abs(this.downX - n) <= 4 && Math.abs(this.downY - n2) < 4) {
                        this.clickCount = this.lastClickTime + 300L > l ? ++this.clickCount : 1;
                        bl2 = true;
                        this.lastClickTime = l;
                    }
                    this.downX = Integer.MIN_VALUE;
                    this.downY = Integer.MIN_VALUE;
                }
            } else if (this.grabbedMouse != null) {
                component = this.grabbedMouse;
            }
            Point point = this.convertPoint(this.component, n, n2, component);
            MouseEvent mouseEvent = new MouseEvent(component, n4, l, this.getCurrentModifiers(n3), point.x, point.y, this.clickCount, n3 == 2 && bl, n3 >= 0 ? n3 : 0);
            this.dispatchEvent(component, mouseEvent);
            if (bl2) {
                component = component2;
                Point point2 = this.convertPoint(this.component, n, n2, component);
                MouseEvent mouseEvent2 = new MouseEvent(component, 500, l, this.getCurrentModifiers(n3), point2.x, point2.y, this.clickCount, false, n3);
                this.dispatchEvent(component, mouseEvent2);
            }
        } else if (bl) {
            // empty if block
        }
    }

    private void sendEnteredEvent(Component component, Component component2, int n, Point point) {
        if (component != null && component != component2) {
            this.sendEnteredEvent(component.getParent(), component2, n, point);
            point = this.convertPoint(component2, point.x, point.y, component);
            MouseEvent mouseEvent = new MouseEvent(component, 504, System.currentTimeMillis(), n, point.x, point.y, 0, false, 0);
            this.dispatchEvent(component, mouseEvent);
        }
    }

    private void sendExitedEvent(Component component, int n, Point point) {
        MouseEvent mouseEvent = new MouseEvent(component, 505, System.currentTimeMillis(), n, point.x, point.y, 1, false, 0);
        this.dispatchEvent(component, mouseEvent);
    }

    private int getCurrentModifiers(int n) {
        int n2 = 0;
        if (this.isKeyDown(56)) {
            n2 |= 0x200;
            n2 |= 8;
        }
        if (this.isKeyDown(184)) {
            n2 |= 0x2000;
            n2 |= 0x20;
        }
        if (this.isKeyDown(29) || this.isKeyDown(157)) {
            n2 |= 0x80;
            n2 |= 2;
        }
        if (this.isKeyDown(42) || this.isKeyDown(54)) {
            n2 |= 0x40;
            n2 |= 1;
        }
        return n2 | this.getButtonMask(n);
    }

    private boolean isKeyDown(int n) {
        return Keyboard.isKeyDown(n);
    }

    private int getButtonMask(int n) {
        int n2 = 0;
        if (Mouse.isButtonDown(0) || n == 1) {
            n2 |= 0x10;
            n2 |= 0x400;
        }
        if (Mouse.isButtonDown(1) || n == 2) {
            n2 |= 8;
            n2 |= 0x800;
        }
        if (Mouse.isButtonDown(2) || n == 3) {
            n2 |= 4;
            n2 |= 0x1000;
        }
        return n2;
    }

    public Component componentAt(int n, int n2) {
        Component component = this.componentAt(n, n2, this.component, true);
        if (component != this.component) {
            return component;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Component componentAt(int n, int n2, Component component, boolean bl) {
        Component component2;
        if (bl && component instanceof JRootPane) {
            component2 = (JRootPane)component;
            component = ((JRootPane)component2).getContentPane();
        }
        component2 = component;
        if (!component.contains(n, n2)) {
            component2 = null;
        } else {
            Object object = component.getTreeLock();
            synchronized (object) {
                if (component instanceof Container) {
                    Container container = (Container)component;
                    int n3 = container.getComponentCount();
                    for (int i = 0; i < n3; ++i) {
                        Component component3 = container.getComponent(i);
                        if (component3 == null || !component3.isVisible() || !component3.contains(n - component3.getX(), n2 - component3.getY())) continue;
                        component2 = component3;
                        break;
                    }
                }
            }
        }
        if (component2 != null) {
            if (component instanceof JTabbedPane && component2 != component) {
                component2 = ((JTabbedPane)component).getSelectedComponent();
            }
            n -= component2.getX();
            n2 -= component2.getY();
        }
        return component2 != component && component2 != null ? this.componentAt(n, n2, component2, bl) : component2;
    }

    private void dispatchEvent(Component component, AWTEvent aWTEvent) {
        if (!SwingUtilities.isEventDispatchThread()) {
            throw new IllegalStateException("not in swing thread!");
        }
        component.dispatchEvent(aWTEvent);
    }
}

