/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.lwjglphet.nodes;

import edu.colorado.phet.common.phetcommon.model.event.Notifier;
import edu.colorado.phet.common.phetcommon.model.event.UpdateListener;
import edu.colorado.phet.lwjglphet.SwingImage;
import edu.colorado.phet.lwjglphet.nodes.AbstractGraphicsNode;
import edu.colorado.phet.lwjglphet.utils.LWJGLUtils;
import java.awt.Dimension;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import javax.swing.JComponent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractSwingGraphicsNode
extends AbstractGraphicsNode {
    protected final JComponent component;
    protected SwingImage componentImage;

    public AbstractSwingGraphicsNode(final JComponent jComponent) {
        this.component = jComponent;
        this.size = jComponent.getPreferredSize();
        jComponent.setSize(jComponent.getPreferredSize());
        jComponent.setDoubleBuffered(false);
        jComponent.setOpaque(false);
        jComponent.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent componentEvent) {
                Dimension dimension = jComponent.getPreferredSize();
                if (!dimension.equals(AbstractSwingGraphicsNode.this.size)) {
                    AbstractSwingGraphicsNode.this.size = dimension;
                    AbstractSwingGraphicsNode.this.rebuildComponentImage();
                    LWJGLUtils.invoke(new Runnable(){

                        public void run() {
                            AbstractSwingGraphicsNode.this.onResize.updateListeners();
                        }
                    });
                }
            }
        });
    }

    public <T> void updateOnEvent(Notifier<T> notifier) {
        notifier.addUpdateListener(new UpdateListener(){

            public void update() {
                AbstractSwingGraphicsNode.this.update();
            }
        }, false);
    }

    public boolean isReady() {
        return this.componentImage != null;
    }

    public void update() {
        if (this.isReady()) {
            this.componentImage.update();
        }
    }

    public JComponent getComponent() {
        return this.component;
    }
}

