/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.lwjglphet.shapes;

import edu.colorado.phet.common.phetcommon.math.Bounds3F;
import edu.colorado.phet.common.phetcommon.math.Triangle3F;
import edu.colorado.phet.common.phetcommon.math.vector.Vector2F;
import edu.colorado.phet.common.phetcommon.math.vector.Vector3F;
import edu.colorado.phet.lwjglphet.utils.GLDisplayList;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjMesh {
    private FloatBuffer positionBuffer;
    private FloatBuffer normalBuffer;
    private FloatBuffer textureBuffer;
    private IntBuffer indexBuffer;
    private boolean hasNormals = false;
    private boolean hasTextures = false;
    private GLDisplayList displayList;
    private List<Triangle3F> triangles = new ArrayList<Triangle3F>();
    private Bounds3F boundingBox;

    public ObjMesh(InputStream inputStream) throws IOException {
        int n;
        Object object2;
        Iterator iterator;
        String string;
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        ArrayList<Vector3F> arrayList = new ArrayList<Vector3F>();
        ArrayList<Vector3F> arrayList2 = new ArrayList<Vector3F>();
        ArrayList<Vector2F> arrayList3 = new ArrayList<Vector2F>();
        ArrayList<List<Object>> arrayList4 = new ArrayList<List<Object>>();
        HashMap<Integer, Integer> hashMap = new HashMap<Integer, Integer>();
        HashMap<Integer, Integer> hashMap2 = new HashMap<Integer, Integer>();
        while ((string = bufferedReader.readLine()) != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
            if (!stringTokenizer.hasMoreTokens() || ((String)((Object)(iterator = stringTokenizer.nextToken()))).equals("#")) continue;
            if (((String)((Object)iterator)).equals("v")) {
                arrayList.add(new Vector3F(Float.parseFloat(stringTokenizer.nextToken()), Float.parseFloat(stringTokenizer.nextToken()), Float.parseFloat(stringTokenizer.nextToken())));
                continue;
            }
            if (((String)((Object)iterator)).equals("vt")) {
                this.hasTextures = true;
                arrayList3.add(new Vector2F(Float.parseFloat(stringTokenizer.nextToken()), Float.parseFloat(stringTokenizer.nextToken())));
                continue;
            }
            if (((String)((Object)iterator)).equals("vn")) {
                this.hasNormals = true;
                arrayList2.add(new Vector3F(Float.parseFloat(stringTokenizer.nextToken()), Float.parseFloat(stringTokenizer.nextToken()), Float.parseFloat(stringTokenizer.nextToken())));
                continue;
            }
            if (((String)((Object)iterator)).equals("f")) {
                object2 = new ArrayList();
                while (stringTokenizer.hasMoreTokens()) {
                    int n2;
                    String[] stringArray = stringTokenizer.nextToken().split("/");
                    int n3 = Integer.parseInt(stringArray[0]);
                    int n4 = stringArray.length > 1 ? Integer.parseInt(stringArray[1]) : 0;
                    int n5 = n2 = stringArray.length > 2 ? Integer.parseInt(stringArray[2]) : 0;
                    if (n4 > 0) {
                        if (hashMap.containsKey(n3)) {
                            if (!((Integer)hashMap.get(n3)).equals(n4)) {
                                // empty if block
                            }
                        } else {
                            hashMap.put(n3, n4);
                        }
                    }
                    if (n2 > 0) {
                        if (hashMap2.containsKey(n3)) {
                            if (!((Integer)hashMap2.get(n3)).equals(n2)) {
                                // empty if block
                            }
                        } else {
                            hashMap2.put(n3, n2);
                        }
                    }
                    object2.add(new Group(n3, n4, n2));
                }
                if (object2.size() == 3) {
                    arrayList4.add((List<Object>)object2);
                    this.triangles.add(new Triangle3F((Vector3F)arrayList.get(((Group)object2.get((int)0)).vertex - 1), (Vector3F)arrayList.get(((Group)object2.get((int)1)).vertex - 1), (Vector3F)arrayList.get(((Group)object2.get((int)2)).vertex - 1)));
                    continue;
                }
                if (object2.size() == 4) {
                    arrayList4.add(Arrays.asList((Group)object2.get(0), (Group)object2.get(1), (Group)object2.get(2)));
                    this.triangles.add(new Triangle3F((Vector3F)arrayList.get(((Group)object2.get((int)0)).vertex - 1), (Vector3F)arrayList.get(((Group)object2.get((int)1)).vertex - 1), (Vector3F)arrayList.get(((Group)object2.get((int)2)).vertex - 1)));
                    arrayList4.add(Arrays.asList((Group)object2.get(0), (Group)object2.get(2), (Group)object2.get(3)));
                    this.triangles.add(new Triangle3F((Vector3F)arrayList.get(((Group)object2.get((int)0)).vertex - 1), (Vector3F)arrayList.get(((Group)object2.get((int)2)).vertex - 1), (Vector3F)arrayList.get(((Group)object2.get((int)3)).vertex - 1)));
                    continue;
                }
                System.out.println("WARNING: non-triangle or quad face!");
                continue;
            }
            if (!((String)((Object)iterator)).equals("usemtl") && !((String)((Object)iterator)).equals("s")) continue;
        }
        inputStream.close();
        this.positionBuffer = BufferUtils.createFloatBuffer(arrayList.size() * 3);
        this.normalBuffer = BufferUtils.createFloatBuffer(arrayList.size() * 3);
        this.textureBuffer = BufferUtils.createFloatBuffer(arrayList.size() * 2);
        this.indexBuffer = BufferUtils.createIntBuffer(arrayList4.size() * 3);
        for (n = 0; n < arrayList.size(); ++n) {
            iterator = (Vector3F)arrayList.get(n);
            this.positionBuffer.put(new float[]{((Vector3F)((Object)iterator)).x, ((Vector3F)((Object)iterator)).y, ((Vector3F)((Object)iterator)).z});
            if (this.hasNormals) {
                object2 = (Vector3F)arrayList2.get((Integer)hashMap2.get(n + 1) - 1);
                this.normalBuffer.put(new float[]{((Vector3F)object2).x, ((Vector3F)object2).y, ((Vector3F)object2).z});
            }
            if (!this.hasTextures) continue;
            object2 = (Vector2F)arrayList3.get((Integer)hashMap.get(n + 1) - 1);
            this.textureBuffer.put(new float[]{((Vector2F)object2).x, ((Vector2F)object2).y});
        }
        for (n = 0; n < arrayList4.size(); ++n) {
            for (Object object2 : (List)arrayList4.get(n)) {
                this.indexBuffer.put(((Group)object2).vertex - 1);
            }
        }
        float f = Float.POSITIVE_INFINITY;
        float f2 = Float.POSITIVE_INFINITY;
        float f3 = Float.POSITIVE_INFINITY;
        float f4 = Float.NEGATIVE_INFINITY;
        float f5 = Float.NEGATIVE_INFINITY;
        float f6 = Float.NEGATIVE_INFINITY;
        for (Vector3F vector3F : arrayList) {
            f3 = Math.min(f3, vector3F.x);
            f2 = Math.min(f2, vector3F.y);
            f = Math.min(f, vector3F.z);
            f6 = Math.max(f6, vector3F.x);
            f5 = Math.max(f5, vector3F.y);
            f4 = Math.max(f4, vector3F.z);
        }
        this.boundingBox = Bounds3F.fromMinMax(f3, f6, f2, f5, f, f4);
        this.displayList = new GLDisplayList(new Runnable(){

            public void run() {
                ObjMesh.this.positionBuffer.rewind();
                ObjMesh.this.normalBuffer.rewind();
                ObjMesh.this.textureBuffer.rewind();
                ObjMesh.this.indexBuffer.rewind();
                GL11.glEnableClientState(32884);
                if (ObjMesh.this.hasTextures) {
                    GL11.glEnableClientState(32888);
                    GL11.glTexCoordPointer(2, 0, ObjMesh.this.textureBuffer);
                }
                if (ObjMesh.this.hasNormals) {
                    GL11.glEnableClientState(32885);
                    GL11.glNormalPointer(0, ObjMesh.this.normalBuffer);
                }
                GL11.glVertexPointer(3, 0, ObjMesh.this.positionBuffer);
                GL11.glDrawElements(4, ObjMesh.this.indexBuffer);
                GL11.glDisableClientState(32884);
                if (ObjMesh.this.hasTextures) {
                    GL11.glDisableClientState(32888);
                }
                if (ObjMesh.this.hasNormals) {
                    GL11.glDisableClientState(32885);
                }
            }
        });
    }

    public void draw() {
        this.displayList.run();
    }

    public List<Triangle3F> getTriangles() {
        return this.triangles;
    }

    public Bounds3F getBoundingBox() {
        return this.boundingBox;
    }

    private static class Group {
        public final int vertex;
        public final int texture;
        public final int normal;

        private Group(int n, int n2, int n3) {
            this.vertex = n;
            this.texture = n2;
            this.normal = n3;
        }
    }
}

