/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.lwjglphet.shapes;

import edu.colorado.phet.common.phetcommon.math.QuaternionF;
import edu.colorado.phet.common.phetcommon.math.vector.Vector3F;
import edu.colorado.phet.lwjglphet.GLOptions;
import edu.colorado.phet.lwjglphet.nodes.GLNode;
import java.nio.FloatBuffer;
import java.nio.ShortBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;

public class PointArc
extends GLNode {
    private boolean approximateSemicircle;
    private Vector3F midpoint;
    private FloatBuffer positionBuffer;
    private ShortBuffer indexBuffer;
    private final float radius;
    private int numFloats;
    private int numVertices;

    public PointArc(Vector3F vector3F, Vector3F vector3F2, float f, int n, Vector3F vector3F3) {
        this.radius = f;
        this.numVertices = n + 1;
        this.numFloats = this.numVertices * 3;
        short s = n + 1;
        this.positionBuffer = BufferUtils.createFloatBuffer(this.numFloats);
        this.indexBuffer = BufferUtils.createShortBuffer(s);
        this.setPositions(vector3F, vector3F2, vector3F3);
        for (short s2 = 0; s2 < s; s2 = (short)(s2 + 1)) {
            this.indexBuffer.put(s2);
        }
    }

    public void renderSelf(GLOptions gLOptions) {
        super.renderSelf(gLOptions);
        this.positionBuffer.rewind();
        this.indexBuffer.rewind();
        GL11.glEnableClientState(32884);
        GL11.glVertexPointer(3, 0, this.positionBuffer);
        GL11.glDrawElements(3, this.indexBuffer);
        GL11.glDisableClientState(32884);
    }

    private void setPositions(Vector3F vector3F, Vector3F vector3F2, Vector3F vector3F3) {
        this.positionBuffer.clear();
        this.approximateSemicircle = PointArc.isApproximateSemicircle(vector3F, vector3F2);
        if (this.approximateSemicircle) {
            Vector3F vector3F4;
            if (vector3F3 == null) {
                vector3F3 = new Vector3F(0.0f, 1.0f, 0.0f);
            }
            Vector3F vector3F5 = (vector3F4 = vector3F.cross(vector3F3).plus(vector3F3.cross(vector3F2))).magnitude() > 0.0f ? vector3F4.normalized() : new Vector3F(0.0f, 0.0f, 1.0f);
            Vector3F vector3F6 = vector3F.minus(vector3F2).normalized();
            Vector3F vector3F7 = vector3F6.minus(vector3F6.times(vector3F5.dot(vector3F6))).normalized();
            Vector3F vector3F8 = vector3F5.cross(vector3F7).normalized();
            for (int i = 0; i < this.numFloats; i += 3) {
                float f = (float)i / (float)(this.numFloats - 3);
                float f2 = (float)((double)f * Math.PI);
                Vector3F vector3F9 = vector3F7.times((float)Math.cos(f2)).plus(vector3F8.times((float)Math.sin(f2))).times(this.radius);
                this.positionBuffer.put(new float[]{vector3F9.x, vector3F9.y, vector3F9.z});
            }
            this.midpoint = vector3F8.times(this.radius);
        } else {
            QuaternionF quaternionF = QuaternionF.getRotationQuaternion(vector3F, vector3F2);
            for (int i = 0; i < this.numFloats; i += 3) {
                float f = (float)i / (float)(this.numFloats - 3);
                new QuaternionF();
                Vector3F vector3F10 = QuaternionF.slerp(new QuaternionF(), quaternionF, f).times(vector3F).times(this.radius);
                this.positionBuffer.put(new float[]{vector3F10.x, vector3F10.y, vector3F10.z});
            }
            this.midpoint = Vector3F.slerp(vector3F, vector3F2, 0.5f).times(this.radius);
        }
    }

    public Vector3F getMidpoint() {
        return this.midpoint;
    }

    public int getNumVertices() {
        return this.numVertices;
    }

    public float[] getVertexData() {
        float[] fArray = new float[this.positionBuffer.limit()];
        for (int i = 0; i < this.positionBuffer.limit(); ++i) {
            fArray[i] = this.positionBuffer.get(i);
        }
        return fArray;
    }

    public static boolean isApproximateSemicircle(Vector3F vector3F, Vector3F vector3F2) {
        return Math.acos(vector3F.dot(vector3F2)) >= 3.12414;
    }

    public void updateView(Vector3F vector3F, Vector3F vector3F2, Vector3F vector3F3) {
        this.setPositions(vector3F, vector3F2, vector3F3);
    }
}

