/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.lwjglphet.shapes;

import edu.colorado.phet.lwjglphet.GLOptions;
import edu.colorado.phet.lwjglphet.nodes.GLNode;
import edu.colorado.phet.lwjglphet.shapes.PointArc;
import java.nio.FloatBuffer;
import java.nio.ShortBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;

public class Sector
extends GLNode {
    private FloatBuffer positionBuffer;
    private ShortBuffer indexBuffer;
    private final PointArc arc;

    public Sector(PointArc pointArc) {
        this.arc = pointArc;
        int n = pointArc.getNumVertices() - 1;
        int n2 = n + 1;
        int n3 = n2 + 1;
        this.positionBuffer = BufferUtils.createFloatBuffer(n3 * 3);
        this.indexBuffer = BufferUtils.createShortBuffer(n3);
        this.setPositions();
        for (int i = 0; i < n3; ++i) {
            this.indexBuffer.put((short)i);
        }
    }

    public void renderSelf(GLOptions gLOptions) {
        super.renderSelf(gLOptions);
        this.positionBuffer.rewind();
        this.indexBuffer.rewind();
        GL11.glEnableClientState(32884);
        GL11.glVertexPointer(3, 0, this.positionBuffer);
        GL11.glDrawElements(6, this.indexBuffer);
        GL11.glDisableClientState(32884);
    }

    private void setPositions() {
        float[] fArray = this.arc.getVertexData();
        this.positionBuffer.clear();
        this.positionBuffer.put(new float[]{0.0f, 0.0f, 0.0f});
        for (float f : fArray) {
            this.positionBuffer.put(f);
        }
    }

    public void updateView() {
        this.setPositions();
    }
}

