/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.moleculeshapes;

import edu.colorado.phet.common.phetcommon.application.PhetApplicationConfig;
import edu.colorado.phet.common.phetcommon.application.PhetApplicationLauncher;
import edu.colorado.phet.common.phetcommon.model.property.Property;
import edu.colorado.phet.common.phetcommon.view.PhetFrame;
import edu.colorado.phet.common.phetcommon.view.controls.PropertyCheckBoxMenuItem;
import edu.colorado.phet.common.phetcommon.view.menu.OptionsMenu;
import edu.colorado.phet.common.piccolophet.PhetTabbedPane;
import edu.colorado.phet.lwjglphet.LWJGLCanvas;
import edu.colorado.phet.lwjglphet.LWJGLPhetApplication;
import edu.colorado.phet.lwjglphet.StartupUtils;
import edu.colorado.phet.moleculeshapes.MoleculeShapesResources;
import edu.colorado.phet.moleculeshapes.MoleculeShapesSimSharing;
import edu.colorado.phet.moleculeshapes.control.MoleculeShapesTeacherMenu;
import edu.colorado.phet.moleculeshapes.dev.DeveloperOptions;
import edu.colorado.phet.moleculeshapes.tabs.moleculeshapes.MoleculeShapesTab;
import edu.colorado.phet.moleculeshapes.tabs.realmolecules.RealMoleculesTab;
import java.io.IOException;
import javax.swing.JMenu;
import javax.swing.JSeparator;

public class MoleculeShapesApplication
extends LWJGLPhetApplication {
    private MoleculeShapesTab tab1;
    private RealMoleculesTab tab2;
    public static final Property<Boolean> showRealMoleculeRadioButtons = new Property<Boolean>(true);
    private static final Property<Boolean> whiteBackground = new Property<Boolean>(false);

    public MoleculeShapesApplication(PhetApplicationConfig phetApplicationConfig) {
        super(phetApplicationConfig);
        this.initModules();
        this.initMenubar();
    }

    private void initModules() {
        PhetFrame phetFrame = this.getPhetFrame();
        final LWJGLCanvas lWJGLCanvas = LWJGLCanvas.getCanvasInstance(phetFrame);
        this.addModule(new PhetTabbedPane.TabbedModule(lWJGLCanvas){
            {
                super(component);
                this.addTab(MoleculeShapesApplication.this.tab1 = new MoleculeShapesTab(lWJGLCanvas, MoleculeShapesResources.Strings.MOLECULE__SHAPES__TITLE, false));
                this.addTab(MoleculeShapesApplication.this.tab2 = new RealMoleculesTab(lWJGLCanvas, MoleculeShapesResources.Strings.REAL__MOLECULES, false, false));
            }
        });
    }

    private void initMenubar() {
        PhetFrame phetFrame = this.getPhetFrame();
        OptionsMenu optionsMenu = new OptionsMenu();
        if (optionsMenu.getMenuComponentCount() > 0) {
            phetFrame.addMenu(optionsMenu);
        }
        phetFrame.addMenu(new MoleculeShapesTeacherMenu(whiteBackground){
            {
                if (MoleculeShapesApplication.this.tab2 != null) {
                    this.add(new PropertyCheckBoxMenuItem(MoleculeShapesSimSharing.UserComponents.showAllLonePairsCheckBox, MoleculeShapesResources.Strings.CONTROL__SHOW_ALL_LONE_PAIRS, ((MoleculeShapesApplication)MoleculeShapesApplication.this).tab2.showAllLonePairs));
                }
            }
        });
        JMenu jMenu = phetFrame.getDeveloperMenu();
        DeveloperOptions.addDeveloperOptions(jMenu, phetFrame);
        jMenu.add(new JSeparator());
        jMenu.add(new PropertyCheckBoxMenuItem(MoleculeShapesSimSharing.UserComponents.devToggleRealModelButtonsVisible, "Show Real/Model radio buttons", showRealMoleculeRadioButtons));
        if (this.tab2 != null) {
            jMenu.add(new PropertyCheckBoxMenuItem(MoleculeShapesSimSharing.UserComponents.devToggle2ndTabBondAngles, "Show 2nd tab bond angles", this.tab2.showBondAngles));
        }
    }

    public static void main(String[] stringArray) throws ClassNotFoundException {
        try {
            StartupUtils.setupLibraries();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        new PhetApplicationLauncher().launchSim(stringArray, "molecule-shapes", "molecule-shapes", MoleculeShapesApplication.class);
    }
}

